#include "defs.h"

/*
utl_rand_num() returns an integer in the range 1..RAND_MAX
*/
#define RAND_MAX	((1 << 31) - 2)

t_int
utl_rand_int(lo, hi)
t_int	lo;
t_int	hi;
{
	t_int	r, range;
	t_double	quotient;

	/*
	Returns a random integer in the range lo to hi inclusive.

	It is not a good idea to use the low order bits of the output
	from utl_rand_num(), as it is a linear congruential generator,
	which means that its low order bits are not particularly
	random.  Instead, we use
		r = (t_int) (range * (utl_rand_num() - 1) / RAND_MAX) + lo
	where utl_rand_num() returns an integer in the range
	1..RAND_MAX.
	*/

	range = hi - lo + 1;
	r = utl_rand_num(1) - 1;
	quotient = (t_double) r / (t_double) RAND_MAX;
	r = (t_int) ((t_double) range * quotient) + lo;
	return r;
}
