/*******************************************************************************
  regula_falsi_zero_aj.c 
********************************************************************************/


#include "kant.h"                                            



t_real 
regula_falsi_zero_aj   (  R      ,
                       start  ,
                       _step   ,
                       func   , 
                       param1 ,
                       param2 ,
                       lambda    )


         t_handle    R;
         t_real    start;
         t_real    _step;
         t_real    (*func) ();
         t_real    param1;
         t_real    param2;    
         t_real    *lambda;

/*******************************************************************************

Description:
                                                             
    Searches for a zero of func. The method used is regula - falsi. 
    To find the zero of func we need some add. information :
      
      1) The function itself (of course) and the parameters of it 
         (named param1 and param2) (these parameters are just 
         optional). 

      2) Since regula - falsi needs an intervall with a zero within
         the first thing we have to do is to find such an intervall.
         Therefor we need a start and the size of the intervall  (step).
         If step is the MEM_NH the function will define step as one.
         Obviously the values of start and step are very important.
         (i.e. if step > min {|x-y| : func (x) = func (y) = 0 ; x<>y}  the 
         function will not work properly).

    The function will return false if no zero was found. 

 


Calling sequence:
                                                           
     t_handle     R           : A real field.
     t_real     start       : starting point.
     t_real     step        : as desc. above
     t_real     func ()     : A function with 4 parameters.
                              (Two are fixed : the real field R and the
                               evaluation point x. The other two parameters
                               are free and given in param1 and param2      )
                              The function func has to return a t_real value.
     t_real     param1      : The first free parameter.
     t_real     param2      : The second free parameter.

     t_real     lambda      : The center of an intervall. Within this intervall
                              there is a point x with func(x) = 0.
                              The size of the intervall depends on the 
                              prec. of R.
                                       
     t_logical    Found       : see above.                           

                                        

     Found = regula_falsi (R,start,step,&func,param1,param2,&lambda);
                                                             
                            
History:                                 
    
        92-06-16 MD    first version



********************************************************************************/
{

     
     t_real     left,right,f_left,f_right;
     t_real     my,f_my,delta,f_delta;
     t_real     l_int,r_int,f_l_int,f_r_int;
     t_real     prec,zero,step,loceps;
     t_real     temp1,temp2;


     t_logical    ok;
                       

  if (_step == MEM_NH) 
    step = conv_int_to_real (R,1);
  else
    step = real_incref (_step);

  ok = find_intervall (R,start,step,func,param1,param2,&left,&right);
                               
  real_delete (&step);

  if (ok) 
  {
    if (anf_print_level > 4) 
    {
      printf ("(left,right) = ");real_write (R,left,5);printf ("   ");
                                 real_write (R,right,5);puts ("");
    }
 

    prec   = real_make (R,10,-(real_dec_prec (R)-2));
    zero   = real_make (R,0,0);
    loceps = real_make(R, 10, -real_dec_prec(R)+5 );  

  
    f_left  = (*func) (R,left,param1,param2);
    f_right = (*func) (R,right,param1,param2);

    ok = TRUE;

    do
      {
        my   = my_value (R,left,right,f_left,f_right);
        f_my = (*func) (R,my,param1,param2);
  

        delta = real_mult (R,prec,my);
      
        l_int = real_subtract (R,my,delta);
        r_int = real_add (R,my,delta);
   
        f_r_int = (*func) (R,r_int,param1,param2);
        f_l_int = (*func) (R,l_int,param1,param2);

        temp1 = real_mult (R,f_r_int,f_l_int);
        temp2 = real_mult (R,f_my,f_left);

/*
puts ("TEMP1 :");real_write (R,temp1,10);puts ("");
puts ("TEMP2 :");real_write (R,temp2,10);puts ("");
*/


        real_delete (&delta);
        real_delete (&l_int);
        real_delete (&r_int);
        real_delete (&f_r_int);
        real_delete (&f_l_int);

     
        if (real_compare_eps (R,temp1,zero,loceps) <= 0)
  	{
/*
puts ("TEMP1 :");real_write (R,temp1,10);
puts ("ZERO  :");real_write (R,zero,10);
*/
          real_delete (&f_my);
          real_delete (&f_left);
          real_delete (&f_right);
     
          real_delete (&left);
          real_delete (&right);


          ok = FALSE;
          *lambda = my;
	}
        else
          if (real_compare_eps (R,temp2,zero,loceps) >= 0) 
	    { 
/*
puts ("  >0");
puts ("TEMP2 :");real_write (R,temp2,10);
puts ("ZERO  :");real_write (R,zero,10);
*/
              real_delete (&left);
              real_delete (&f_left);
            
  
              left = my;
              f_left = f_my;
             }
             else
               {
/*
puts ("  <0");
puts ("TEMP2 :");real_write (R,temp2,10);
*/
                 real_delete (&right);
                 real_delete (&f_right);

                 right = my;
                 f_right = f_my;
               }    
          
        real_delete (&temp1);
        real_delete (&temp2);


        if ((ok) && (anf_print_level > 4))
        {
          printf ("(left,right) = ");
          real_write (R,left,5);printf ("   ");
          real_write (R,right,5);puts ("");
        }
  
      }
      while (ok);          

      real_delete (&loceps);
      real_delete (&prec);
      real_delete (&zero);


    if (anf_print_level > 4) 
    {
      printf ("lambda = ");real_write (R,*lambda,5);puts ("");
    } 
                
      return TRUE;   
  }
  
  return FALSE;
}
