#include "kant.h"
#include "thue.h" 

matrix
thue_bd_approximation_basis WITH_5_ARGS( 
                thue,                   th,
                t_handle,               R,
                vector,                 alpha,
                t_real,                 E,
                t_real *,               div
)                
/******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg, i, j, r;
        integer_big     hh1;
	t_real		m_one, h1, h2, h3;
        order           ord;
        matrix          basis;
        t_handle        R_ord;

        ord = thue_order(th);
        R_ord = order_reals(ord);
        deg = thue_abs_degree(th);
        m_one = conv_int_to_real(R, -1);
        r = order_r(ord);

        basis = mat_new(r, r);
        for (i=1; i<=r; i++)
                for (j=1; j<r; j++)
                        if (i != j)
                                {
	                        mat_elt(basis, i, j) = conv_int_to_real(R, 0);
                                }
                        else
                                {
		                mat_elt(basis, i, j) = conv_int_to_real(R, 1);
                                }
        for (i=1; i<r; i++)
                {
                h1 = thue_conv_real_to_real(R_ord, vec_entry(alpha, i), R);
                mat_elt(basis, i, r) = real_mult(R, h1, m_one);
                real_delete(&h1);
                }
        mat_elt(basis, r, r) = thue_conv_real_to_real(R_ord, E, R); 
        *div = real_incref(mat_elt(basis, r, r) );

        return basis;
}
