#include "kant.h"
#include "thue.h"


t_int
thue_bd_precision WITH_1_ARG(
                thue,          th
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;

        t_int           deg, r, precision;
        t_real          h0, h1, h2, h3, h4, h5, h6, h7, B1;
        order           ord;
        t_handle        R;
         
        ord = thue_order(th);
        deg = thue_abs_degree(th);
        B1 = thue_B1(th);
        r = order_r(ord);
        R = thue_reals(th);
        
        h0 = conv_int_to_real(R, 2);
        h1 = conv_int_to_real(R, r);
        h2 = conv_int_to_real(R, 4);
        h3 = real_divide(R, h1, h2);
        h4 = real_real_power(R, h0, h3);
        real_delete(&h0);
        real_delete(&h2);
        real_delete(&h3);
        h0 = conv_double_to_real(R, 1.0E3);
        h3 = real_power(R, h0, deg);
        real_delete(&h0);
        h5 = conv_int_to_real(R, r-1);
        h6 = real_real_power(R, B1, h5);
        h7 = real_mult(R, h3, h6);
        real_delete(&h3);
        real_delete(&h6);
        h2 = real_divide(R, h1, h5);
        real_delete(&h1);
        real_delete(&h5);
        h5 = real_real_power(R, h7, h2);
        real_delete(&h7);
        real_delete(&h2);
        h3 = real_mult(R, h4, h5);
        real_delete(&h4);
        real_delete(&h5);
        h4 = real_power(R, h3, 2);
        real_delete(&h3);
        h2 = real_log(R, h4);
        real_delete(&h4);
        h3 = conv_double_to_real(R, 2.3);
        h1 = real_divide(R, h2, h3);
        real_delete(&h2);
        real_delete(&h3);
        h2 = real_abs(R, h1);
        real_delete(&h1);
        precision = conv_real_to_int_ceil(R, h2);
        real_delete(&h2);

        return precision;
}
