#include "kant.h"
#include "thue.h"
  
vector
thue_poly_zeroes WITH_4_ARGS(
	t_handle,		reals,
        t_poly,                 pol,
        t_int,                  deg,
        t_int *,                r1
)
/*******************************************************************************
 
Description:
 
       Computes the zeroes of Z-polynomial pol. 
 
Calling sequence:
 
History:
 
*******************************************************************************/
{
	block_declarations;
 
	mp_float	zero, temp, tempr, tempi, temp1, eps;
	mp_vector	Ar, Xr, Xi;
	mp_length	base_places, old_base_places;
	integer_small	i, j, j1, j2, r2, r12, r;
	dyn_arr_handle	arr;
	order		z;
        vector          zeroes;

	base_places = real_beta_prec(reals);
        zeroes = vec_new(deg);
	
/*
    Casting coefficients of polynomial into mp_vectors for mp_poly
*/
	Ar = mp_vector_alloc(deg+1);
             
	z  = m_z_str_incref(structure_z);
	arr = poly_to_dyn_arr(z, pol);
 
	for (i=0; i<=deg; ++i)
		{
		mp_vector_el(Ar,i) = mp_alloc(real_base, base_places);
		conv_int_to_mp(dyn_arr_element(arr, i), mp_vector_el(Ar, i));
		integer_delref(dyn_arr_element(arr, i));
		}

	dyn_arr_delete(&arr); 
	ring_delete(&z);                               

/*
    	starting values for iteration
*/
 	
	Xr = mp_vector_alloc(deg);
	Xi = mp_vector_alloc(deg);
	for (i=0; i<deg; ++i)
		{                  
		mp_vector_el(Xr,i) = mp_alloc(real_base, base_places);
		mp_vector_el(Xi,i) = mp_alloc(real_base, base_places);
		}
	mp_init_roots(deg, Xr, Xi);
 
/*
    	Now we compute the zeroes
*/
	mp_poly(deg, Ar, 0, Xr, Xi);
         
/*
   	We have to find out r1 and r2!
    	Everything below the square root of epsilon is regarded as zero.
*/
	eps   = mp_alloc(real_base, base_places);
        zero  = mp_alloc(real_base, base_places);
        
        mp_epsilon(eps);
/*	mp_sqrt(eps, eps);	*/
	mp_int_to_mp(0, zero);
 
	for (i=0; i<deg; ++i)
		{
		if (mp_cmp_abs(mp_vector_el(Xr, i), eps) < 0)
			mp_copy(zero, mp_vector_el(Xr, i));
 
		if (mp_cmp_abs(mp_vector_el(Xi, i), eps) < 0)
			mp_copy(zero, mp_vector_el(Xi, i));
		}
 
/*
     	First we identify the real zeroes
*/
	*r1 = 0;
 
	for (i=0; i<deg; ++i)
		{
		if (!mp_cmp(mp_vector_el(Xi, i), zero))
			{
			temp1 = mp_alloc(real_base, base_places);
			mp_copy(mp_vector_el(Xr, i), temp1);
			vec_entry(zeroes, ++*r1) = mp_to_real(temp1);
			}
		}

/*
     	Now the complex ones...
*/
	r2 = 0;
	j1 = *r1;
	j2 = *r1 + (deg-*r1)/2;
        
	if (*r1<deg)
		{
		for (i=0; i<deg; ++i)
			{
			if (mp_cmp(mp_vector_el(Xi, i), zero) > 0)
				{
				tempr = mp_alloc(real_base,base_places);
				mp_copy(mp_vector_el(Xr, i), tempr);
				vec_entry(zeroes, ++j1) = mp_to_real(tempr);
	
				tempi = mp_alloc(real_base,base_places);
				mp_copy(mp_vector_el(Xi, i), tempi);
				vec_entry(zeroes, ++j2) = mp_to_real(tempi);
			   	++r2;
				}
			}
		}  
 
	if(*r1 + r2 + r2 != deg)
		{
/*		printf("r1 = %d\n",*r1);
		printf("r2 = %d\n", r2);               
*/		for(i=*r1+1; i<=deg; i++)
			{
                	vec_entry(zeroes, i)= conv_int_to_real(reals, 1);
                        }
		*r1 = deg;
/*		printf("thue_poly_zeroes: Something went wrong.\n");
*/		} 
 
	mp_delete_float(eps);     
	mp_delete_float(zero);
 
	for (i=0; i<deg; ++i)
		{
		mp_delete_float(mp_vector_el(Ar, i));
		mp_delete_float(mp_vector_el(Xr, i));
		mp_delete_float(mp_vector_el(Xi, i));
		}
	mp_delete_float(mp_vector_el(Ar, deg));
 
	mp_delete_vector(Ar);
	mp_delete_vector(Xr);
	mp_delete_vector(Xi);

        return zeroes;
 
}
 
