#include "kant.h"
#include "thue.h" 

t_real
thue_solution_upper_bound2 WITH_4_ARGS(
                thue,           th,
                t_real,         T,
                t_real,         A,
                t_real,         t_ymax
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	t_int		deg, r;
	t_handle	R;
	t_real		h1, h2, h3, h4;
        t_real          m, f0;
        order           ord;

        ord = thue_order(th);
        deg = order_abs_degree(ord);
        R = thue_reals(th);
        r = order_r(ord); 
        
        h1 = real_inverse(R, T);
        m = conv_int_to_real(R, thue_M(th));
        f0 = conv_int_to_real(R, thue_coeff(th, 1));
        h2 = real_divide(R, m, f0);
        real_delete(&m);
        real_delete(&f0);
        h3 = real_abs(R, h2);
        real_delete(&h2);
        h2 = conv_int_to_real(R, deg);
        h4 = real_inverse(R, h2);
        real_delete(&h2);
        h2 = real_real_power(R, h3, h4);
        real_delete(&h3);
        real_delete(&h4);
        h3 = real_mult(R, h1, h2);
        real_delete(&h1);
        real_delete(&h2);
        h1 = real_min(R, t_ymax, h3);
        real_delete(&h3);

        h2 = conv_int_to_real(R, 2);
        h3 = real_add(R, A, h2);
        h4 = real_divide(R, h3, h2);
        real_delete(&h2);
        real_delete(&h3);
        h2 = conv_int_to_real(R, deg-2);
        h3 = real_inverse(R, h2);
        real_delete(&h2);
        h2 = real_real_power(R, h4, h3);
        real_delete(&h3);       
        real_delete(&h4);
        h3 = real_mult(R, h1, h2);
        real_delete(&h1);
        real_delete(&h2); 

        
        return h3;
}
