#include "kant.h"
#include "thue.h" 

t_real
thue_waldschmidt_C WITH_2_ARGS(
                t_handle,         R,
                integer_big,    k
)
/*******************************************************************************

Description: 
                             min(8k+52,10k+33,9k+39)     2k
        Computation of      2                         * k    as t_real

Calling sequence: 
	
History: 

       92-09-16 JPS     written
*******************************************************************************/
{
	block_declarations;
 
        integer_big     h1,h2,h21,h22,h23,h3,h4,h5,h6;
	t_real		ret;

        h1 = integer_mult(k, 8);
        h21 = integer_add(h1, 52);
        integer_delete(&h1);
        h1 = integer_mult(k, 10);
        h22 = integer_add(h1, 33);
        integer_delete(&h1);
        h1 = integer_mult(k, 9);
        h23 = integer_add(h1, 39);
        integer_delete(&h1);
        if (integer_compare(h21, h22)==-1)
                h1 = integer_incref(h21);
        else
                h1 = integer_incref(h22);

        if (integer_compare(h1, h23)==-1)
                h2 = integer_incref(h1);
        else
                h2 = integer_incref(h23);
        integer_delete(&h1);
        integer_delete(&h21);
        integer_delete(&h22);
        integer_delete(&h23);
        h3 = integer_mult(k, 2);
        h4 = integer_power(k, h3);
        h5 = integer_power(2, h2);
        h6 = integer_mult(h5, h4);
        integer_delete(&h2);
        integer_delete(&h3);
        integer_delete(&h4);
        integer_delete(&h5);
        ret = conv_int_to_real(R, h6);
        integer_delete(&h6);
        return ret;
}
