      SUBROUTINE SLSTO(SKALAR,VEKTOR)
C
C     ************************************************************
C     *                                                          *
C     *       S U B R O U T I N E    S L S T O                   *
C     *                                                          *
C     ************************************************************
C
*DOC             Umspeichern einer kurzen als lange Zahl
C
C                AENDERUNGEN: JS 20.2.1987
C
**DOC BESETZT EINE LANGE ZAHL MIT DEM SKALAR
**DOC VORAUSSETZUNG:  IABS(SKALAR) < BASIS**4
C
*****************************************************************
C
*DOC             XXXXXXXXXXXx XXx XXXXXXX
**DOC
*INDEX  xxxxxx(AM/2): xXXXX xXXXXXXXX; xXXXX ( xX xXXX)
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       Reference(s):
**DOC
**DOC   (2) PARAMETER (IN):
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       -
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       START       END
**DOC       OVFLOW      AINORM
**DOC       HERMIT      DETI4
**DOC       COPYI4
**DOC       -
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       DEBUG
**DOC       FIELD
**DOC       LARITH
**DOC       -
**DOC
**DOC   (8) AUTHOR(S):
**DOC       XX       XX.XX.88
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       -
**DOC
%include 'larith.inc'
C
C     .. SCALAR ARGUMENTS ..
         INTEGER           SKALAR
C
C     .. ARRAY ARGUMENTS ..
         INTEGER           VEKTOR(*)
C
C     .. LOCAL SCALARS ..
         INTEGER           X1,X2
******************************************************************
*
         X1 = IABS(SKALAR)
         IF (X1.GE.LBASIS) THEN
            X2 = 2
            VEKTOR(3) = X1/LBASIS
            IF(VEKTOR(3).GE.LBASIS) THEN
               VEKTOR(4) = VEKTOR(3)/LBASIS
               VEKTOR(3) = VEKTOR(3) - LBASIS*VEKTOR(4)
               X2 = 3
            ENDIF
            VEKTOR(2) = MOD(X1,LBASIS)
         ELSE IF (X1.NE.0) THEN
            VEKTOR(2) = X1
            X2 = 1
         ELSE
            X2 = 0
         ENDIF
         IF (SKALAR.LT.0) THEN
            VEKTOR(1) = -X2
         ELSE
            VEKTOR(1) = X2
         ENDIF
C
      RETURN
      END
