
#ifndef INCLUDED_MAT_SPEC_H
#define INCLUDED_MAT_SPEC_H


#include "integer.e"
#include "ring.h"

/*
** Structure of the block containing a matrix ring.
*/

typedef struct
	{
		t_ring_common	ring_hdr;

		t_handle		mt_coeff_ring;
		integer_small	mt_dimension;
		integer_small	mt_dim2;

		integer_small	mt_ngens;
		t_handle		mt_gens;
		t_handle		mt_gen_names;

		t_handle		mt_ech_gens;
		integer_small	mt_ech_dim;

		t_handle		mt_vspace;
	}
	t_mat_table;

/*
** Access to the information stored in the matrix ring.
*/

#define mat_access(h)		((t_mat_table *) ring_access(h))

#define mat_coeff_ring(h)	(mat_access(h) -> mt_coeff_ring)
#define ring_coeff_ring		mat_coeff_ring
#define mat_dimension(h)	(mat_access(h) -> mt_dimension)
#define mat_dim2(h)		(mat_access(h) -> mt_dim2)
#define ring_dimension		mat_dimension
#define mat_gens(h)		(mat_access(h) -> mt_gens)
#define ring_gens		mat_gens
#define mat_ech_gens(h)		(mat_access(h) -> mt_ech_gens)
#define ring_ech_gens		mat_ech_gens
#define mat_ngens(h)		(mat_access(h) -> mt_ngens)
#define ring_ngens		mat_ngens
#define mat_gen_names(h)	(mat_access(h) -> mt_gen_names)
#define ring_gen_names		mat_gen_names
#define mat_vspace(h)		(mat_access(h) -> mt_vspace)
#define ring_vspace		mat_vspace
#define mat_ech_dim(h)		(mat_access(h) -> mt_ech_dim)
#define ring_ech_dim		mat_ech_dim

/*
** Type of a matrix.
*/

typedef t_handle matrix;

/*
** Increase reference count of a matrix by one.
*/

#define mat_incref	block_incref

/*
** Decrease reference count of a matrix by one, deleting entries if count
** reaches zero. Entries of matrix *ph are elements of ring cr.
*/

#define mat_delref( cr, ph ) \
	( ( block_has_other_refs( *(ph) ) \
		? (( block_decref_delete( *(ph) ) ), 0) \
		: (( mat_delete_entries( cr, *(ph) ), mat_delete( ph ) ), 0) \
	  ), *(ph) = 0 )

/*
** Hard delete. Deletes the block of a matrix without regard to reference
** counts.
*/

#define mat_delete	mem_delete_hptr

/*
** Prototypes of the functions and macros for multiple usage of functions.
*/

#include "mat_protos.h"


#endif /* INCLUDED_MAT_SPEC_H */

