/******************************************************************************/

#define USE_SBRK

#define TRACE_ALLOCS

#define INIT_HANDLES		10000
#define EXTEND_HANDLES		10000

#define TRACE_H_INITIAL		10
#define TRACE_SIZE_INITIAL	10

/******************************************************************************/

#if 0
#define CLASS_S			(1.5)
#define CLASS_LOG_S		(0.4054651081081643)
#define CLASS_LIMIT		49
#endif

#define CLASS_S			(1.75)
#define CLASS_LOG_S		(0.5596157879354226)
#define CLASS_LIMIT		34

/*
> x := 1.75; print Log(x), Ceiling(Log(2^32 + 0.0) / Log(x) - 6);
0.55961578793542268627 34
*/


#define CLASS_SMALL_LIMIT	100

/******************************************************************************/

#define BYTES_TO_PTRS(n)	(((n) + 3) >> 2)
#define PTRS_TO_BYTES(n)	((n) << 2)
#define UWORDS_TO_PTRS(n)	(n)
#define PTRS_TO_UWORDS(n)	(n)

/******************************************************************************/

#ifdef USE_SBRK

#define INITIAL_DATA_EXTENSION_SIZE	100000

#define SBRK_ALIGNMENT		256
#define SBRK_FAIL		((t_ptr)-1)

extern void *sbrk();

#define SBRK(n)			(t_ptr)sbrk(n)
#define SBRK_ALIGN(n)		(((n) + SBRK_ALIGNMENT) & ~(SBRK_ALIGNMENT - 1))
#define SBRK_ALIGN_DOWN(n)	((n) & ~(SBRK_ALIGNMENT - 1))
#define SBRK_INITIAL_ALIGN()	sbrk(					\
				    sizeof(t_ptr) -			\
				    (int)sbrk(0) % sizeof(t_ptr) +	\
				    HEADER_SIZE * sizeof(t_ptr)		\
				)
#define	CHECK_FOR_GAP(gap)	if (!memi_base_mem)			\
				{					\
				    sbrk(				\
					SBRK_ALIGN(HEADER_SIZE * sizeof(t_ptr))\
				    );					\
				    gap = FALSE;			\
				}					\
				else { 					\
				    t_ptr	s = sbrk(0);		\
				    if (s < memi_high_mem)		\
					DIE("process data space has shrunk!"); \
				    gap = s > memi_high_mem;		\
				}

#else

#define xINITIAL_DATA_EXTENSION_SIZE	1000000
#define INITIAL_DATA_EXTENSION_SIZE	1000

#define SBRK_ALIGNMENT		256
#define SBRK_FAIL		((t_ptr)0)

extern void *malloc();

#define SBRK(n)			malloc(n)
#define SBRK_ALIGN(n)		(n)
#define SBRK_ALIGN_DOWN(n)	(n)
#define SBRK_INITIAL_ALIGN()
#define	CHECK_FOR_GAP(gap)	((gap) = TRUE)

#endif
