
/*  modint.e
** Package for integers modulo m.
*/

#ifndef	_MODINT_E
#define	_MODINT_E

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


extern integer_big modint_add_f P_((integer_big,integer_big,integer_big));
extern integer_big modint_all_sqrts P_((integer_big,integer_big,faclst *));
extern integer_big modint_div P_((integer_big,integer_big,integer_big));
extern integer_big modint_exp P_((integer_big,integer_big,integer_big));
extern integer_big modint_hom P_((integer_big,integer_big));
extern integer_big modint_invert P_((integer_big,integer_big));
extern integer_big modint_mult_f P_((integer_big,integer_big,integer_big));
extern integer_big modint_negate_f P_((integer_big,integer_big));
extern integer_big modint_sqrt P_((integer_big,integer_big,faclst *));
extern integer_big modint_subtract_f P_((integer_big,integer_big,integer_big));
extern integer_big modint_symm_rep P_((integer_big,integer_big));
extern t_logical modint_is_unit P_((t_handle,t_int));

#define modint_mult( mod, a, b ) \
		( (mod) < DELTA \
		  ? ( ((a) * (b)) % (mod) ) \
		  : modint_mult_f( (mod), (a), (b) ) \
		)

#define modint_add( mod, a, b ) \
		( (mod) < integer_BETA \
		  ? ( (a) + (b) >= (mod) \
		      ? (a) + (b) - (mod) \
		      : (a) + (b) \
		    ) \
		  : modint_add_f( (mod), (a), (b) ) \
		)


#define modint_subtract( mod, a, b ) \
		( (mod) < integer_BETA \
		  ? ( (a) - (b) >= 0 \
		      ? (a) - (b) \
		      : (a) - (b) + (mod) \
		    ) \
		  : modint_subtract_f( (mod), (a), (b) ) \
		)

#define modint_negate( mod, a ) \
		( (a) == 0 \
		  ? 0 \
		  : ( (mod) < integer_BETA \
		      ? ((mod) - (a)) \
		      : integer_subtract( (mod), (a) ) \
		    ) \
		)

#endif	/* _MODINT_E */
