//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : base_vector.h 
// Author      : Frank Lehmann (FL), Markus Maurer (MM),
//               Thomas Papanikolaou (TP), Patrick Theobald (PT)
// Last change : FL/MM, Feb 15 1995, initial version
//		 FL/MM, Sep 29 1995, changed "debug_handler" to "debug_handler_l"
//

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
// *
// *    File        :  comparator.h
// *
// *    Description :  -) definition of template class 'comparator<T>'
// *			  to provide functions for comparing elements 
// * 		          of any type T
// *
// *		       -) to use this class comparator, T must support 
// *                      the operators < , <= , ==
// *
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


#ifndef LIDIA_COMPARATOR_H
#define LIDIA_COMPARATOR_H

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:lidia.h>
#include <string.h>
#else
#include <LiDIA/lidia.h>
#include <string.h>
#endif

template <class T> 
class comparator
{

  public:
  
  /**
   ** by reference 
   **/
      
  static inline int less_than(const T & a, const T & b) 
    {return (a < b);}

  static inline int less_equal(const T & a, const T & b) 
    {return (a <= b);}

  static inline int greater_than(const T & a, const T & b) 
    {return (b < a);}

  static inline int greater_equal(const T & a, const T & b) 
    {return (b <= a);}

  static inline int equal(const T & a, const T & b) 
    {return ( b == a );}

  /** 
   ** by value
   **/

  static inline int val_less_than(T a, T b) 
    {return (a < b);}

  static inline int val_less_equal(T a, T b) 
    {return (a <= b);}

  static inline int val_greater_than(T a, T b) 
    {return (b < a);}
  
  static inline int val_greater_equal (T a, T b) 
    {return (b <= a);}

  static inline int val_equal(T a, T b) 
    {return (b == a);}

  /**
   ** min and max
   **/ 

  static inline T min(T a, T b)
    {return (a <= b ? a : b);}

  static inline T max(T a, T b)
    {return (b <= a ? a : b);}
};

class comparator < char * >
{
  public:

  /**
   ** by reference 
   **/

  static inline int less_than(char *a, char *b) 
    {return (strcmp(a,b) < 0);}
  
  static inline int less_equal(char *a, char *b)
    {return (strcmp(a,b) <= 0);}

  static inline int greater_than(char *a, char *b)
    {return (strcmp(a,b) > 0);}
  
  static inline int greater_equal(char *a, char *b)
    {return (strcmp(a,b) >= 0);}

  static inline int equal(char *a, char *b)
    {return (strcmp(a,b) == 0);}

  /**
   ** by value
   **/

  static inline int val_less_than(char *a, char *b) 
    {return (strcmp(a,b) < 0);}

  static inline int val_less_equal (char *a, char *b)
    {return (strcmp(a,b) <= 0);}

  static inline int val_greater_than(char *a, char *b)
    {return (strcmp(a,b) > 0);}

  static inline int val_greater_equal(char *a, char *b)
    {return (strcmp(a,b) >= 0);}

  static inline int val_equal(char *a, char *b)
    {return (strcmp(a,b) == 0);}
  
  /**
   ** min and max
   **/

  static inline char* min(char *a, char *b)
    {return ((strcmp(a,b) <= 0) ? a : b);}

  static inline char* max(char *a, char *b)
    {return ((strcmp(a,b) >= 0) ? a : b);}
};

#endif


