//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : file_vector.h 
// Author      : Frank Lehmann (FL), Markus Maurer (MM),
//               Thomas Papanikolaou (TP), Patrick Theobald (PT) 
// Last change : FL/MM, Feb 15 1995, initial version
//               FL/MM, May 10 1995, clean-up
//		 FL/MM, May 15 1995, changed type of size variables 
//				     into base_vector<T>::size_type
//		 FL/MM, Jul  6 1995, replaced base_vector<T>::size_type by lidia_size_t
//               FL/MM, Jul 24 1995, added 'const' to T* parameters of constructors
//		 FL/MM, Aug 30 1995, changed "error_handler" to "lidia_error_handler"
//               PT     Oct 28 1995, new template concept
//

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
// *
// *    File        :  file_vector.h
// *
// *    Description :  -) definition of template class 'file_vector<T>'
// *                      to allow use of vectors with file-I/O-functions
// *
// *                   -) virtual base class is 'base_vector<T>'
// *
// *                   -) uses template class 'file_io_class<T>'
// *
// *		       -) requirements on type T are given by those
// *		          of the base class and the file_io_class
// *
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

#ifndef LIDIA_FILE_VECTOR_H
#define LIDIA_FILE_VECTOR_H

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <unistd.h>
#include <LiDIA:base_vector.h>
#include <LiDIA:file_io_class.h>
#else
#include <unistd.h>
#include <LiDIA/base_vector.h>
#include <LiDIA/file_io_class.h>
#endif

template <class T> 
class file_vector : public virtual base_vector < T >
{  
  
  /**
   ** constructors
   **/
  
 public:

  inline file_vector() : base_vector < T > (0, FIXED) {}
  inline file_vector(lidia_size_t all, char md) : base_vector < T > (all, md) {}
  inline file_vector(lidia_size_t all, lidia_size_t len) : base_vector < T > (all, len, FIXED) {}
  inline file_vector(lidia_size_t all, lidia_size_t len, char md) : base_vector < T > (all, len, md) {}
  inline file_vector(const base_vector < T > & v) : base_vector < T > (v, FIXED) {}
  inline file_vector(const base_vector < T > & v, char md) : base_vector < T > (v, md) {}
  inline file_vector(const T *v, lidia_size_t len) : base_vector < T > (v, len, FIXED) {}
  inline file_vector(const T *v, lidia_size_t len, char md) : base_vector < T > (v, len, md) {}
  
  /**
   ** destructor 
   **/

 public:

  inline ~file_vector() {}
  
  /**
   ** reading from / writing to file 
   **/
  
 public:
 
#ifndef HEADBANGER
  void write_to_file(FILE *fp) const;              /* writes the vector to file in binary-format */
  void read_from_file(FILE *fp);                   /* reads a vector from file in binary-format */
  
  void append_b(FILE *fp) const;                   /* appends the vector to file in binary format */
  void append_b(FILE *fp, lidia_size_t n) const;   /* appends the (n+1)-st element of the vector to file */
  
  void print_to_file(FILE *fp) const;              /* writes the vector to file in ASCII-format */  
  void scan_from_file(FILE *fp);                   /* reads a vector from file in ASCII-format */  
  
  void append_a(FILE *fp) const;                   /* appends the vector to file in ASCII-format */
  void append_a(FILE *fp, lidia_size_t n) const;   /* appends the (n+1)-st element of the vector to file */
#endif

};

#ifdef LIDIA_INCLUDE_C
#include <LiDIA/file_vector.c>
#endif

#endif




