/******************************************************************************
 ** LiDIA's Temporary Variable Manager
 ** Original Author: Ralf Dentzer
 ** Rewritten By: Thomas Papanikolaou
 ** Copyright (c) by the LiDIA Group
 ** All rights reserved
 *****************************************************************************/

#if !defined(MM_H)
#define MM_H

#include <LiDIA/config.h>
#ifdef HAVE_STDLIB_H
#ifdef __GNUG__
#include <stdlib.h>
#endif
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

/**
 ** Interface to the real allocators
 **
 ** void *MM_CALLOC(size_t nmemb, size_t size);
 ** void *MM_MALLOC(size_t size);
 ** void MM_FREE(void *ptr);
 ** void *MM_REALLOC(void *ptr, size_t size);
 **/

#ifndef MM_CALLOC
#define MM_CALLOC calloc
#endif
#ifndef MM_MALLOC
#define MM_MALLOC malloc
#endif
#ifndef MM_FREE
#define MM_FREE free
#endif
#ifndef MM_REALLOC
#define MM_REALLOC realloc
#endif

/**
 ** the storage unit of one memory element
 **/

#define mm_unit char
#define mm_unit_str "char"
#define mm_unit_size sizeof(char)

/**
 ** the type of the counter of storage units
 **/

typedef int mm_size_t;

/**
 ** the minimum allocation size = 2^0 = 1 char
 ** the maximum allocation size = 2^28 chars
 **
 **/

#define MM_LISTMIN 0
#define MM_LISTMAX (sizeof(long)*8-4)

/**
 ** define MM_STATISTICS if you want to have statistics
 **/

#ifdef MM_STATISTICS
#define MM_STATISTIC(x) x
#else
#define MM_STATISTIC(x)
#endif

/**
 ** varieties of extern function declarations
 **/

#ifdef __cplusplus
#define EXTERN_FUNCTION( rtn, args ) extern "C" { rtn args; }
#define _VOID_			/* anachronism */
#else
#ifdef __STDC__
#ifdef __PARC__
#define EXTERN_FUNCTION( rtn, args ) rtn()
#define _VOID_
#define const
#else
#define EXTERN_FUNCTION( rtn, args ) rtn args
#define _VOID_ void
#endif
#else
#define EXTERN_FUNCTION( rtn, args ) rtn()
#define _VOID_
#define const
#endif
#endif

/**
 ** the public interface
 **/

EXTERN_FUNCTION(void mm_initialize, (_VOID_));

EXTERN_FUNCTION(void *mm_malloc, (mm_size_t));
EXTERN_FUNCTION(void *mm_malloc_without_init, (mm_size_t));
EXTERN_FUNCTION(void *mm_calloc, (mm_size_t, mm_size_t));
EXTERN_FUNCTION(void *mm_calloc_without_init, (mm_size_t, mm_size_t));
EXTERN_FUNCTION(void *mm_realloc, (void *, mm_size_t));
EXTERN_FUNCTION(void  mm_free, (void *));
EXTERN_FUNCTION(void  mm_free_with_size, (void *, mm_size_t));
EXTERN_FUNCTION(void  mm_collect, (_VOID_));

EXTERN_FUNCTION(void  mm_statistics, (_VOID_));
EXTERN_FUNCTION(void  mm_long_statistics, (_VOID_));

EXTERN_FUNCTION(void  mm_message, (char *, char *));
EXTERN_FUNCTION(void  mm_warning, (char *, char *));
EXTERN_FUNCTION(void  mm_error, (char *, char *));

#endif
