//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : dlp_appl.c
// Author      : Damian Weber (DW)
// Last change : TP, Aug 8 1995, initial version
//

#include <LiDIA/dlp.h>
#include <LiDIA/timer.h>
#include <stdlib.h>
#include <strstream.h>

#define PROGNAME "dlp_appl"

void help()
{
   cerr << "Solve the Discrete Logarithm Problem a^x=b mod p, p prime" << "\n";
   cerr << "\n" << "usage: dlp_appl a b p" << "\n" << "\n";
   exit(0);
}

int  flag_set(int argc, char **argv, char *s) 
     {
     int j;

     for (j=1;j<=argc-1;j++)
	 if (!strcmp(argv[j],s))
	    return j;
     return 0;
     }

int  main(int argc, char **argv)
{
  bigint a,b,p;
  rational_factorization f;
  
  if (flag_set(argc,argv,"-h") || argc!=4)
    help();
  
  if (!string_to_bigint(argv[1],a)) help();
  if (!string_to_bigint(argv[2],b)) help();
  if (!string_to_bigint(argv[3],p)) help();

  dl(a,b,p,1);
}

