.TH DSVDC L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
DSVDC
.SH DECLARATIONS
.hy 0
.nf
subroutine DSVDC(X,ldx,n,p,s,e,U,ldu,V,ldv,work,job,info)
integer ldx, n, p, ldu, ldv, job, info
double precision X(ldx,p),s(mm),e(p),U(ldu,kk),V(ldv,p),work(n)
Note: mm = min(n+1,p), kk determined by job, see parameters below.
.fi
.SH SYNOPSIS
FORTRAN subroutine taken from LINPACK to
compute the singular value decomposition of a matrix.
.PP
For \fIX\fR an \fIn\fR by \fIp\fR matrix, there is
an \fIn\fR by \fIn\fR orthogonal matrix \fIU\fR
and a \fIp\fR by \fIp\fR orthogonal matrix \fIV\fR
such that \fItrans(U)\*(STX\*(STV~=~D\fR
where \fID\fR is the diagonal matrix \fIdiag(s1,s2,...,sm)\fR,
and \fIm~=~min(n,p)\fR.
The scalars, \fIs1, s2, ..., sm\fR, are the singular values of \fIX\fR,
and \fIs1~>=~s2~>=~s3~>=~...~>=~sm~>=~0\fR.
The columns of \fIU\fR are
the left singular vectors of \fIX\fR and
the columns of \fIV\fR are the right
singular vectors of \fIX\fR.
.PP
These factors are all that are needed by many applications.
This decomposition can be used to determine rank of \fIX\fR, to
compute projections, to compute solutions to least square
problems, to compute or use the pseudo-inverse, and to
estimate the condition number of \fIX\fR.

For solving square systems \fIAx~=~b\fR, where
neither the singular values nor the singular vectors are
needed, see the manual page
on DGECO.  If \fIA\fR is positive definite, see the manual page
on DPOCO.  For orthogonal decompositions, and other methods
of solving least square problems and computing projections, see
DQRDC.

For more information see Chapter 11 of the LINPACK Users'
Guide.
.SH PARAMETERS
.TP 10
X(ldx,p)
Contains the matrix whose singular value decomposition
is to be computed.  \fIX\fR is destroyed by DSVDC.
.TP 10
ldx
The leading dimension of \fIX\fR.
.TP 10
n
Number of rows of \fIX\fR.
.TP 10
p
Number of columns of \fIX\fR.
.TP 10
s(mm)
\fImm~=~min(n+1,p)\fR
.br
On return,
the first \fImin(n,p)\fR elements are the singular values of \fIX\fR
arranged in descending order.
.TP 10
e(p)
On return,
if the decomposition was completed, see \fIinfo\fR, the vector
\fIe\fR will contain all zeros.
.TP 10
U(ldu,kk)
\fIkk\fR depends on \fIjob\fR
.br
On return, \fIU\fR
contains the left singular vectors if their computation
has been requested.
Depending on the \fIjob\fR requested, the value of \fIkk\fR
must be as follows.
If \fIjob~<=~11, kk~=~n\fR.
If \fIjob~>=~\fR20\fI, kk~=~min(n,p)\fR.  When \fIn~<=~p\fR or
\fIjob~>=~\fR20, then \fIU\fR may be identified with \fIX\fR
in the calling sequence.  This allows
\fIX\fR to be overwritten with the left singular vectors.
\fIU\fR is not referenced if \fIjob~<~\fR10.
.TP 10
ldu
Leading dimension of \fIU\fR.
.TP 10
V(ldv,p)
On return, \fIV\fR
contains the right singular vectors if their computation
has been requested.  See \fIjob\fR.
If \fIn~>=~p, V\fR may be identified with \fIX\fR in the calling sequence.
This allows
\fIX\fR to be overwritten with the right singular vectors.
Both \fIU\fR and \fIV\fR cannot be identified with
\fIX\fR.  \fIV\fR is not referenced if
the right singular vectors are not requested.
.TP 10
ldv
Leading dimension of \fIV\fR.
.TP 10
work(n)
Work space.
.TP 10
job
Indicates request for singular vectors.  It has the
decimal expansion AB with the following meaning.
.RS
.TP 8
A = 0
do not compute the left singular vectors;
.TP 8
A = 1
compute all \fIn\fR left singular vectors;
.TP 8
A > 1
compute the first \fImin(n,p)\fR left singular vectors;
.TP 8
B = 0
do not compute the right singular vectors;
.TP 8
B >= 1
compute the right singular vectors;
.RE
.TP 10
info
Error indicator of sorts.
.br
If \fIinfo~=~0\fR, the decomposition has been completed correctly
and the singular values are contained in \fIs\fR.
Otherwise, the singular values of \fIX\fR are those of the
upper bidiagonal matrix with \fIs\fR as its diagonal and \fIe\fR as
its super diagonal.
.SH Details
The decomposition is divided into two parts.  First, the
matrix \fIX\fR is reduced to bidiagonal form by the means of
alternating left and right Householder transformations.
The second part consists of reducing the bidiagonal form
to diagonal by applying a variant of the \fIQR\fR algorithm.
The complete algorithm is described in Chapter 11 of
the LINPACK Users' Guide.
.sp
For a matrix of full rank \fIn\fR, the condition number can be
determined by \fIs(1)/s(n)\fR.
For \fIk~<~p\fR, if \fIs(k)~<>~0\fR and \fIs(k+1)~=~0\fR then
the matrix \fIX\fR has rank \fIk\fR.  Because of errors, particularly
round-off error, it is rare to compute singular values
that are exactly zero.  Therefore, \fIk\fR can be determined when
some \fIs(k+1)\fR becomes relatively negligible.  This method is
sensitive to scaling in \fIX\fR.  It is advised that for rank
determination and other applications of the singular value
decomposition, the user read Chapter 11 of the LINPACK Users'
Guide.
.SH EXAMPLE
.if t .ta .13i .5i .75i 1i
.if n .ta 3 7 11 14
.nf
C	Sample program for DSVDC
C
		double precision X(25,15),U(20,20),V(15,15)
		double precision s(25),e(25),work(25)
		integer ldx,ldu,ldv,n,p,job,info,i,j
		data ldx, ldu, ldv / 25, 20, 15 /
		n = 15
		p = 10
		do 20 j = 1,p
			do 10 i = 1,n
				a(i,j) = ...
	10		continue
	20	continue
C
C	Solve for the singular values and both right
C	and left singular vectors
C	Use lobo.lib matrix printer MPRINT
		job = 11
		call DSVDC(X,ldx,n,p,s,e,U,ldu,V,ldv,work,11,info)
		if (info .ne. 0) then
			write(6,*) 'calculations not completed, info = ',info
			write(6,*) 'singular values are same as this bidiagonal matrix'
			write(6,*) 'diagonal'
			mprint(s,ldx,p,1,0)
			write(6,*) 'super diagonal"
			mprint(e,ldx,p-1,1,0)
		else
			write(6,*) 'singular values'
			mprint(s,ldx,p,1,0)
			write(6,*) 'left singular vectors'
			mprint(U,ldu,n,n,0)
			write(6,*) 'right singular vectors'
			mprint(V,ldv,p,p,0)
		endif
		end
.fi
.SH SECONDARY ROUTINES
BLAS: DAXPY, DDOT, DSCAL, DASUM, IDAMAX, DSWAP
.SH SEE ALSO
DPOCO, DGECO, DSVDC, BLAS
.SH REFERENCES
.fi
Dongarra, J. J., J. R. Bunch, C. B. Moler, G. W. Stewart,
\fBLINPACK Users' Guide\fR,
Society for Industrial and Applied Mathematics, Philadelphia, 1979.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
