.TH DSYEV L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.SH NAME
DSYEV
.SH DECLARATIONS
.nf
subroutine DSYEV(A, lda, n, d, X, work, job, info)
integer lda, n, job, info
double precision A(lda,n), d(n), X(lda,n), work(3\*(STn)
.fi
.SH SYNOPSIS
FORTRAN subroutine for computing the eigenvalues and, optionally, the
eigenvectors of real symmetric matrices.  Uses several subroutines from
a new version of EISPACK[1] currently under development.
.SH PARAMETERS
.TP 10
A(lda,n)
On input to DSYEV, \fIA\fR contains the matrix whose eigenvalues are
desired.  Only the diagonal and lower triangle are referenced.
If desired, the strict upper triangle may be used for other storage.
Upon return, the lower triangle of \fIA\fR has been altered.
.TP 10
lda
The leading dimension of the array \fIA\fR.
.TP 10
n
The order of the matrix.
.TP 10
d(n)
The eigenvalues, in decreasing order.
.br
\fId(1)\fR >= \fId(2)\fR >= ... >= \fId(n)\fR
.TP 10
X(lda,n)
The eigenvectors.
.br
\fIX(:,j)\fR is an eigenvector associated with \fId(j)\fR.
.br
The eigenvectors are orthogonal, i.e. \fIX'^\*(STX\fR = \fII\fR,
where \fIX'\fR is the transpose of \fIX\fR
.TP 10
work(3\*(STn)
Work space.
.br
The dimension must be at least \fIn\fR if \fIjob\fR = 0,
or 3\*(ST\fIn\fR if \fIjob\fR > \fI0\fR.
.TP 10
job
Indicator of what is to be computed.
.RS
.br
.ns
.IP "0 - "  6
compute eigenvalues only.
.br
.ns
.IP "1 - "
compute both eigenvalues and eigenvectors.
.RE
.TP 10
info
Should be zero.  If it isn't, multiply the input matrix by a
huge scale factor, say 10\*(ST\*(ST30, call DSYEV again, then divide
the resulting eigenvalues by the scale factor.  If the nonzero
value of \fIinfo\fR persists,
please contact the UNM Math Software Project.
.SH DETAILS
The matrix is first transformed to symmetric tridiagonal
form using Householder orthogonal similarity transformations.
A new `perfect shift' version of the QR algorithm is used
to reduce this tridiagonal matrix to a diagonal matrix.  
If requested, the eigenvectors are produced from information
accumulated during the calculation of the eigenvalues.
.PP
The generally available edition of EISPACK described in the reference
cited below includes a driver subroutine, RS, and secondary routines,
TRED1, TRED2, TQLRAT and TQL2, to carry out a similar calculation.
This new version should be somewhat faster and, in a few cases, more
accurate.
.SH EXAMPLE
.nf
.if t .ta .13i .5i .75i 1i
.if n .ta 3 7 11 14
c		Program to compute the eigenvalues and eigenvectors
c		of a real, symmetric matrix.
c
		double precision A(50,50),d(50),X(50,50),work(50)
		integer n,lda
		data lda /50/
		n = ...
c
c		It is only necessary to generate the lower triangle.
c
		do 20 i = 1, n
			do 10 j = 1, i
				a(i,j) = ...
	10		continue
	20	continue
c
		call dsyev(A,lda,n,d,X,work,1,info)
		if (info .ne. 0) write(6,\*(ST) 'dsyev did not converge'
c
		write(6,\*(ST) 'The eigenvalues are:'
		do 30 i = 1, n
			write(6,\*(ST) d(i)
	30	continue
c
c		Use LOBO.LIB subroutine mprint to print the eigenvectors
c
		write(6,\*(ST) 'The eigenvectors are:'
		call mprint(X,lda,n,n,0)
		...
		end
.fi
.SH SECONDARY ROUTINES
.nf
BLAS: DNRM2
.SH REFERENCES
.fi
.IP [1]
B. T. Smith, J. M. Boyle, J. J. Dongarra, B. S. Garbow,
Y. Ikebe, C. B. Moler and V. C. Klema.
\fIMatrix Eigensystem Routines -- EISPACK User's Guide\fR,
\fBLecture Notes in Computer Science No. 6\fR,
Second Edition, Springer-Verlag, 1976.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
