.TH EPSLON L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
EPSLON
.SH DECLARATIONS
.nf
double precision function EPSLON(x)
double precision x
.fi
.SH SYNOPSIS
FORTRAN subroutine
to estimate unit roundoff in quantities of size x.
This routine is machine independent.  See details below.
.SH PARAMETERS
.TP 8
x
EPSLON returns the machine error relative to \fIx\fR.
.SH DETAILS
Machine unit roundoff \fIeps\fR is defined to be the largest
machine representable quantity such that (1.d0~+~\fIeps\fR)~=~1.d0.
.PP
The function EPSLON should function properly on all systems
satisfying the following two assumptions,
.IP 1.
The base used in representing floating point
numbers is not a power of three.
.IP 2.
The quantity \fIa\fR~=~4/3 is represented to
the accuracy used in floating point variables
that are stored in memory.
.LP
Under these assumptions, it should be true that,
.IP i)
\fIa\fR is not exactly equal to four-thirds,
.IP ii)
the quantity (3.d0*(\fIa\fR~-~1.d0)~-~1.d0) is not exactly zero.
Specifically,
.IP iii)
\fIb\fR~=~\fIa\fR~-~1.d0 has a zero for its last bit or digit,
.IP iv)
\fIc\fR~=~\fIb\fR~+~\fIb\fR~+~\fIb\fR is not exactly equal to one,
.IP v)
\fIeps\fR~=~\fIc\fR~-~1.d0 measures the separation of 1.0 from
the next larger floating point number.
.PP
This routine is taken from the EISPACK8x proposal.
The developers of EISPACK would appreciate being informed
about any systems where these assumptions do not hold.
.SH CODE
.nf
.if t .ta .13i .5i
.if n .ta 3 7
C
		DOUBLE PRECISION A,B,C,EPS
		A = 4.0D0/3.0D0
	10	B = A - 1.0D0
		C = B + B + B
		EPS = DABS(C-1.0D0)
		IF (EPS .EQ. 0.0D0) GO TO 10
		EPSLON = EPS*DABS(X)
		RETURN
		END
.SH AUTHOR
.fi
Cleve Moler, Department of Computer Science, University of New
Mexico
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
