.ps 11
.vs 13
.TH LOBO.LIB L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
LOBO.LIB - MATHEMATICAL SOFTWARE LIBRARY
.SH SYNOPSIS
.PP
LOBO.LIB is a small library of mathematical
software routines, collected and maintained by the Mathematical
Software Project of the Computer Science Department, with the cooperation
of the Mathematics Department and the
Computer Center, for use at the University of New Mexico.
.PP
This library is a collection of routines
taken from several well-known libraries and packages and some
original contributions.
We strongly recommend that users of LOBO.LIB
also become familiar with the commercially supported mathematical software 
libraries available from NAG (Numerical Algorithms Group) and IMSL 
(International Mathematical and Statistical Libraries).
.PP 
This library is small, comprised of 18 basic modules consisting
of approximately 50 sub-routines and functions.
The primary version of the library is written in Fortran.  A Pascal 
version is under development. 
.SH DOCUMENTATION
Documentation is provided 
on-line and as a manual available from the Mathematical Software
Project.
Related routines are documented as a group.
.SH SOURCE
The source for all the routines used in lobo.lib is in the 
directory /u1/lobolib.
.SH ROUTINES
.PP
The routines are grouped by mathematical application.
.RS 8
Linear algebra: BLAS
.br
Linear systems: DGECO, DPOCO, DQRDC, DSVDC
.br
Eigenvalues and eigenvectors: DGEEV, DSYEV
.br
Cubic spline: SPCOEF, SVALUE
.br
Quadrature: KQUAD, RQUAD
.br
Differential equations solver: RKF45
.br
Random number generation: URAND, GRAND
.br
Root finding: ZERO
.br
Minimization: FMIN
.br
Machine error: EPSLON
.br
Matrix, vector printer: MPRINT, FORMZ
.RE
.LP
A brief summary of routines follows.
.sp
.TP 4
BLAS
Basic Linear Algebra Subroutines: IDAMAX,
DASUM, DAXPY, DCOPY, DDOT, DNRM2, DROT, DROTG, DSCAL, and DSWAP.
.TP 4
DGECO, DGEFA, DGESL, DGEDI
Linear systems: operations on a general square matrix.
Uses BLAS as secondary level routines.
.RS 8
.IP "DGECO~-" 10
factor and estimate condition
.IP "DGEFA~-"
factor only
.IP "DGESL~-"
use factors from DGECO to solve a system
.IP "DGEDI~-"
use factors from DGECO to compute the determinant and/or the inverse
.RE
.TP 4
DGEEV
Determine all eigenvalues and associated eigenvectors of a general matrix.
Uses BLAS as secondary level routines.
.TP 4
DPOCO, DPOFA, DPOSL, DPODI
Linear systems: operations on a positive definite matrix.
Uses BLAS as secondary level routines.
.RS 8
.IP "DPOCO~-" 10
factor and estimate condition
.IP "DPOFA~-"
factor only
.IP "DPOSL~-"
use factors from DPOCO to solve a system
.IP "DPODI~-"
use factors from DPOCO to compute the determinant and/or the inverse
.RE
.TP 4
DQRDC, DQRSL
Linear systems: orthogonal operations on an n by p matrix.
Uses BLAS as secondary level routines.
.RS 8
.IP "DQRDC~-" 10
orthogonal triangular decomposition of an n by p matrix, may
be used for least squares data fitting, determining linear
dependencies in the matrix, and estimating the condition of
the matrix
.IP "DQRSL~-"
use factors from DQRDC to solve a system, and to compute
transformations and projections
.RE
.TP 4
DSVDC
Linear systems: singular value decomposition of an n by p matrix.
Uses BLAS as secondary level routines.
.TP 4
DSYEV
Determine all eigenvalues and associated eigenvectors of a symmetric matrix.
Uses BLAS as secondary level routines.
.TP 4
EPSLON
Calculates the relative accuracy of floating
point arithmetic, i.e., round-off error, for all machines.
.TP 4
FMIN
Finds an unconstrained, local minimum of a continuous,
single-valued, real function.
.TP 4
FORMZ
Prints a number in hex.
.TP 4
GRAND
Generates random numbers from normalized distribution.
.TP 4
KQUAD
Uses an adaptive quadrature algorithm based on
the Gauss-Kronrod (3,7) rule.
.TP 4
MPRINT
`Pretty' prints a matrix or vector.
Uses FORMZ as a secondary routine.
.TP 4
RKF45
Solves initial value problems for non-stiff and mildly stiff
differential equations.
The model driver routine ODE45 is provided to demonstrate how
to take advantage of the flags returned from RKF45.
A new routine for solving differential equations is under
development for APS[1] and is expected to replace RKF45.
.TP 4
RQUAD
Uses an adaptive quadrature algorithm based on the Gauss 8 rule.
.TP 4
SPCOEF, SVALUE
Routines for computing cubic interpolatory splines, taken from APS[1].
.RS 8
.IP "SPCOEF~-" 10
Calculates the coefficients of the spline.
.IP "SVALUE~-"  
Uses the coefficients from SPCOEF to evaluate the spline at a
given point.
.RE
.TP 4
URAND
Generates random numbers from a uniform distribution.
.TP 4
ZERO
Finds a root of a continuous, single-valued, real function.
.SH 
REFERENCES
.IP [1]
Allen, R., S. Pruess, L. Shampine, \fBNumerical Computing\fR,
Math 375 Class Notes, 1984-85. (To be published)
.IP [2]
Dongarra, J.J., J. R. Bunch, C. B. Moler, G. W. Stewart,
\fBLINPACK Users' Guide\fR, Society for Industrial and Applied
Mathematics, Philadelphia, 1979.
.IP [3]
Forsythe, G. E., M. A. Malcolm, C. B. Moler, \fBComputer Methods
for Mathematical Computations\fR, Prentice-Hall, Edgewood Cliffs,
N. J., 1977.
.IP [4]
Moler, C. B., \fIMATLAB Users' Guide\fR, Department of Computer
Science, College of Engineering, University of New Mexico, Technical
Report CS81-1 (Revised), 1982.
.IP [5]
Smith, B. T., J. M. Boyle, J. J. Dongarra, B. S. Garbow,
Y. Ikebe, C. B. Moler and V. C. Klema.
\fIMatrix Eigensystem Routines -- EISPACK User's Guide\fR,
\fBLecture Notes in Computer Science No. 6\fR,
Second Edition, Springer-Verlag, 1976.
