.TH URAND L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST  *
.tr ~
.hy 0
.SH NAME
URAND
.SH DECLARATIONS
.nf
real function URAND(iy)
integer iy
.fi
.SH SYNOPSIS
.PP
FORTRAN function that returns a
uniform random number in the interval [0,1).
Note, the value returned is a single precision number.
.PP
This random number generator is based on theory and suggestions
given in Knuth[2] and is discussed in Forsythe[1].
.PP
For random numbers generated from a normal (Gaussian) distribution,
see GRAND.
.SH PARAMETERS
.TP 8
iy
The seed to initialize the sequence of random numbers
generated, then is used by the routine to store information
used by subsequent calls.
.br
Prior to the first call to URAND, \fIiy\fR
should be initialized to an arbitrary, non-negative
integer.  A common choice is to set \fIiy\fR~=~0.
The calling program should not alter the value of \fIiy\fR
between subsequent calls to URAND.
.SH DETAILS
.PP
URAND falls in the classification of \fIpseudorandom\fR number
generators.  That is, the
sequence of random numbers is reproducible.
.PP
URAND calculates a sequence of random non-negative integers in the
range of the computer by setting
\fIiy(n+1)\fR~=~\fI(a\*(STiy(n)\fR~+~\fIc)~~modulo~m,~~~\fIn\fR~>=~1,
where \fIiy(0)\fR is the initial integer chosen by the user
and \fIa, c\fR and \fIm\fR have been chosen according
to the theory described in Knuth[2].
URAND returns a real value in the interval [0,1) by scaling
\fIiy(n+1)\fR.
.SH EXAMPLES
.if t .ta .13i .5i .75i 1i
.if n .ta 3 7 11 14
.nf
c 		Program to flip a coin
c
		integer i, iy
		real urand
		iy = 0
		do 10 i = 1,10
			if (urand(iy) .lt. 0.5) then
				write(6,*) 'heads'
			else
				write(6,*) 'tails'
			endif
	10	continue
		end

c		Program segment to simulate the roll of a die.
c
		integer i, iy, iroll
		real urand
		iy = 0
		do 10 i = 1,...
			iroll = int(6.0\*(STurand(iy)) + 1
			write(6,*)'The roll is ',iroll
	10	continue
		end
.fi
.SH SEE ALSO
GRAND
.SH REFERENCES
.IP [1]
Forsythe, G. E., M. A. Malcolm, C. B. Moler, \fBComputer Methods
for Mathematical Computations\fR. Prentice-Hall, Inc., 1977.
.IP [2]
Knuth, D. E., \fISeminumerical Algorithms\fR,
\fBThe Art of Computer Programming, Vol  2.\fR
Addison-Wesley, 1969.
.SH FURTHER INFORMATION
.nf
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM 87131
