      SUBROUTINE DSYACM (A,LDA,N,Z)
      INTEGER LDA,N
      DOUBLE PRECISION A(LDA,*),Z(LDA,*)
C
C     DSYACM, Double precision SYmmetric ACcuMulation.
C     DSYACM accumulates the transformations developed by DSYTRE.
C
C     ON ENTRY
C
C        A       DOUBLE PRECISION (LDA,N)
C                Output from DSYTRE.
C
C        LDA     INTEGER
C                The leading dimension of the arrays A and Z.
C
C        N       INTEGER
C                The order of the matrices A and Z.
C
C     ON RETURN
C
C        A       Unchanged, unless overwritten by  Z .
C
C        Z       DOUBLE PRECISION (LDA,N)
C                An orthogonal matrix  Z  so that
C                Z'*(input to DSYTRE)*Z is tridiagonal.
C
C     EISPACK 8X. This version dated 06/12/84 .
C     Cleve Moler, University of New Mexico.
C
C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

C
      DOUBLE PRECISION BETA,GAMMA
      INTEGER I,J,K
C
C     Let H(k) = k-th Householder reflection (see DSYTRE).
C     This subroutine computes Z = H(2)*H(3)* ... *H(N-1) .
C     H(k) differs from the identity only in rows and columns k through n.
C     The vector  u  defining H(k) is stored in A(i,k-1), i = k,...,n .
C     The details are tricky because  A  and  Z  may be the same array.
C     Loops on I are candidates for vectorization.
C
      Z(1,N) = 0.0D0
      Z(N,N) = 1.0D0
      DO 60 K = N-1, 2, -1
         BETA = -A(K,K-1)
         Z(1,K) = 0.0D0
         Z(K,K) = 1.0D0 + BETA
         DO 10 I = K+1, N
            Z(I,K) = -A(I,K-1)
   10    CONTINUE
         DO 30 J = K+1, N
            GAMMA = 0.0D0
            DO 20 I = K+1, N
               GAMMA = GAMMA + Z(I,J)*A(I,K-1)
   20       CONTINUE
            Z(K,J) = -GAMMA
   30    CONTINUE
         IF (BETA .EQ. 0.0D0) GO TO 60
         DO 50 J = K+1, N
            GAMMA = -Z(K,J)/BETA
            DO 40 I = K+1, N
               Z(I,J) = Z(I,J) + GAMMA*A(I,K-1)
   40       CONTINUE
   50    CONTINUE
   60 CONTINUE
      DO 70 I = 1, N
         Z(I,1) = 0.0D0
   70 CONTINUE
      Z(1,1) = 1.0D0
      RETURN
      END
