      SUBROUTINE SPCOEF(N,X,F,B,C,D,IFLAG)
      INTEGER N,IFLAG
      DOUBLE PRECISION X(N),F(N),B(N),C(N),D(N)
C
C  CALCULATE COEFFICIENTS FOR SMOOTH CUBIC INTERPOLATORY SPLINE.
C
C  INPUT PARAMETERS
C    N = NUMBER OF DATA POINTS
C    X = VECTOR OF VALUES OF THE INDEPENDENT VARIABLE.  IT
C        IS ASSUMED THAT X(I) .LT. X(I+1) FOR ALL I.
C    F = VECTOR OF VALUES OF THE DEPENDENT VARIABLE
C  OUTPUT PARAMETERS
C    B = VECTOR OF S'(X(I)) VALUES
C    C = VECTOR OF S''(X(I))/2 VALUES
C    D = VECTOR OF S'''(X(I)+)/6 VALUES
C    IFLAG = 0   NORMAL RETURN
C          = -1  INPUT N .LE. 1
C          = -2  X VECTOR IS INCORRECTLY ORDERED
C
C THE VECTORS X,F,B,C,D MUST BE DIMENSIONED AT LEAST N
C
C LOCAL VARIABLES
      INTEGER I,K,NM1
      DOUBLE PRECISION H,FP1,FPN,P
C
C  CALCULATE COEFFICIENTS FOR TRI-DIAGONAL SYSTEM:
C  STORE SUB-DIAGONAL IN B, DIAGONAL IN D, DIFF. QUOTIENT IN C.
C
      IF (N .LE. 1) GOTO 70
      B(1) = X(2)-X(1)
      IF (B(1) .LE. 0.) GOTO 80
      C(1) = (F(2)-F(1))/B(1)
      IF (N .GT. 2) GOTO 10
      B(1) = C(1)
      C(1) = 0
      D(1) = 0
      IFLAG = 0
      RETURN
   10 D(1) = 2.D0*B(1)
      NM1 = N-1
      DO 20 I = 2,NM1
         B(I) = X(I+1)-X(I)
         IF (B(I) .LE. 0.) GOTO 80
         C(I) = (F(I+1)-F(I))/B(I)
         D(I) = 2.D0*(B(I)+B(I-1))
   20 CONTINUE
      D(N) = 2.D0*B(N-1)
C
C  CALCULATE ESTIMATES FOR END SLOPES.
C
      FP1 = C(1)-B(1)*(C(2)-C(1))/(B(1)+B(2))
      IF (N .GT. 3) FP1 = FP1+B(1)*((B(1)+B(2))*(C(3)-C(2))
     &  /(B(2)+B(3))-C(2)+C(1))/(X(4)-X(1))
      FPN = C(N-1)+B(N-1)*(C(N-1)-C(N-2))/(B(N-2)+B(N-1))
      IF (N .GT. 3) FPN = FPN+B(N-1)*(C(N-1)-C(N-2)-(B(N-2)
     &  +B(N-1))*(C(N-2)-C(N-3))/(B(N-2)+B(N-3)))/(X(N)-X(N-3))
C
C  CALCULATE RIGHT-HAND-SIDE, STORE IN C.
C
      C(N) = 3.D0*(FPN-C(N-1))
      DO 30 K = 2,NM1
         I = N-K+1
         C(I) = 3.D0*(C(I)-C(I-1))
   30 CONTINUE
      C(1) = 3.D0*(C(1)-FP1)
C
C  SOLVE TRIDIAGONAL SYSTEM.
C
      DO 40 K = 2,N
         P = B(K-1)/D(K-1)
         D(K) = D(K)-P*B(K-1)
         C(K) = C(K)-P*C(K-1)
   40 CONTINUE
      C(N) = C(N)/D(N)
      DO 50 I = 1,NM1
         K = N-I
         C(K) = (C(K)-B(K)*C(K+1))/D(K)
   50 CONTINUE
C
C  CALCULATE SPLINE COEFFICIENTS.
C
      DO 60 I = 1,NM1
         H = X(I+1)-X(I)
         D(I) = (C(I+1)-C(I))/(3.D0*H)
         B(I) = (F(I+1)-F(I))/H-H*(C(I)+H*D(I))
   60 CONTINUE
      IFLAG = 0
      RETURN
   70 IFLAG = -1
      RETURN
   80 IFLAG = -2
      RETURN
      END
