C      ________________________________________________________
C     |                                                        |
C     |    COMPUTE THE DETERMINANT OF A FACTORED BAND MATRIX   |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --BFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         BDET,E--DETERMINANT IS BDET*10.**E (E INTEGER) |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,ALOG10,DLOG10                |
C     |________________________________________________________|
C
      FUNCTION BDET(E,A)
      REAL A(1),D,F,G
      DOUBLE PRECISION C
      INTEGER E,H,I,J,K,L,M,N
      D = A(1)
      IF ( ABS(D) .EQ. 1231 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH BFACT BEFORE',
     1'COMPUTING DETERMINANT'
      STOP
10    E = 0
      IF ( D .LT. 0. ) GOTO 70
      N = A(2)
      IF ( N .EQ. 1 ) GOTO 80
      D = 1.
      F = 2.**64
      G = 1./F
      H = 64
      J = A(4) + A(5) + 1
      M = 1 + J + A(4)
      K = 6
      L = 5 - M + M*N
      N = 0
      DO 40 I = K,L,M
           N = N + 1
           IF ( A(I) .GT. N ) D = -D
           D = D*A(I+J)
20         IF ( ABS(D) .LT. F ) GOTO 30
           E = E + H
           D = D*G
           GOTO 20
30         IF ( ABS(D) .GT. G ) GOTO 40
           E = E - H
           D = D*F
           GOTO 30
40    CONTINUE
      D = D*A(J+L+1)
      IF ( E .NE. 0 ) GOTO 50
      BDET = D
      RETURN
50    IF ( D .EQ. 0. ) GOTO 90
      C = ALOG10(ABS(D)) + E*DLOG10(2.D0)
      E = C
      C = C - E
      IF ( C .LE. 0.D0 ) GOTO 60
      C = C - 1
      E = E + 1
60    F = 10.**C
      IF ( D .LT. 0. ) F = -F
      BDET = F
      RETURN
70    BDET = 0.
      RETURN
80    BDET = A(7)
      RETURN
90    E = 0
      GOTO 70
      END
