C
C      ________________________________________________________
C     |                                                        |
C     | BALANCE A COMPLEX MATRIX AND REDUCE TO HESSENBERG FORM |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --COMPLEX ARRAY CONTAINING MATRIX        |
C     |                 (LENGTH AT LEAST 1 + N(N+2))           |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |         W     --WORK ARRAY WITH AT LEAST N COMPLEX     |
C     |                 ELEMENTS                               |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         A     --HESSENBERG MATRIX                      |
C     |                                                        |
C     |   BUILTIN FUNCTIONS: AIMAG,CABS,CONJG,REAL,SQRT        |
C     |   PACKAGE FUNCTIONS: MAG,SQR                           |
C     |   PACKAGE SUBROUTINES: CBAL,CPACK                      |
C     |________________________________________________________|
C
      SUBROUTINE CAHESS(A,LA,N,W)
      REAL R,S,SQR,T,U,MAG
      COMPLEX A(1),W(1),V,X,Y,Z
      INTEGER C,D,E,G,H,I,J,K,L,LA,M,N,O,P,Q
      IF ( LA .GT. N ) CALL CPACK(A,LA,N)
      I = N*N
      U = 0.
      M = N + 1
      O = M + 1
      E = I + M
      J = I + 1
      CALL CBAL(A,N,N,W,A(J))
      J = M
      K = I
      C = 0
      G = E
      H = E + N
10    C = C + 1
      G = G + 1
      A(G) = REAL(W(C))
      IF ( G .EQ. H ) GOTO 20
      G = G + 1
      A(G) = AIMAG(W(C))
      IF ( G .LT. H ) GOTO 10
C     ---------------------------
C     |*** SHIFT MATRIX DOWN ***|
C     ---------------------------
20    V = A(E+1)
30    K = K - N
40    A(I+J) = A(I)
      I = I - 1
      IF ( I .GT. K ) GOTO 40
      J = J - 1
      IF ( K .GT. 0 ) GOTO 30
      A(1) = 2233
      A(2) = N
      K = 4
      L = O
      D = 1
      C = 2
50    IF ( C .GE. N ) GOTO 210
      P = K + 1
      DO 60 I = P,L
60         IF ( MAG(A(I)) .NE. 0. ) GOTO 70
      A(L+1) = (0.,0.)
      GOTO 200
70    T = MAG(A(K))
      IF ( T .NE. 0. ) U = 1./T
      R = SQR(A(K),U)
      DO 90 J = I,L
           S = MAG(A(J))
           IF ( S .LE. T ) GOTO 80
           U = 1./S
           R = SQR(A(J),U) + R*(T*U)**2
           T = S
           GOTO 90
80         R = R + SQR(A(J),U)
90    CONTINUE
      S = T*SQRT(R)
      Z = A(K)
      T = CABS(Z)
      U = 1./SQRT(S*(S+T))
      IF ( T .NE. 0. ) Z = Z/T
      IF ( T .EQ. 0. ) Z = (1.,0.)
      I = L
C     ------------------------------------
C     |*** COMPUTE HOUSEHOLDER MATRIX ***|
C     ------------------------------------
100   A(I+1) = U*CONJG(A(I))
      I = I - 1
      IF ( I .GT. K ) GOTO 100
      A(K) = -Z*S
      A(P) = CONJG(Z)*U*(T+S)
      H = L
      DO 110 I = 1,N
110        W(I) = (0.,0.)
C     --------------------------------------
C     |*** MULTIPLY FROM RIGHT AND LEFT ***|
C     --------------------------------------
120   H = H + M
      Y = CONJG(A(P))
      P = P + 1
      Q = H - N
      DO 130 I = 1,D
130        W(I) = W(I) + Y*A(I+Q)
      J = K - D
      Z = (0.,0.)
      DO 140 I = C,N
           X = A(I+Q)
           Z = Z + X*A(I+J)
140        W(I) = W(I) + X*Y
      A(H+1) = Z
      IF ( H .LT. E ) GOTO 120
      Z = (0.,0.)
      H = L + 1
      P = K + 1
      J = C - P
      DO 150 I = P,H
           Z = Z + W(I+J)*A(I)
150        A(I) = CONJG(A(I))
      DO 160 I = C,N
160        W(I) = W(I) - Z*A(I-J)
      H = L
C     -----------------------------------
C     |*** UPDATE COEFFICIENT MATRIX ***|
C     -----------------------------------
170   G = H + 2
      Q = H + M
      H = H + C
      Z = A(Q+1)
      Y = CONJG(A(P))
      P = P + 1
      J = 1 - G
      DO 180 I = G,H
180        A(I) = A(I) - W(I+J)*Y
      I = H
      H = Q
      Q = K - I
      G = I + 1
      DO 190 I = G,H
190        A(I) = A(I) - A(I+Q)*Z - W(I+J)*Y
      IF ( H .LT. E ) GOTO 170
200   K = K + O
      L = L + M
      D = C
      C = C + 1
      GOTO 50
210   A(E+1) = V
      RETURN
      END
