C
C      ________________________________________________________
C     |                                                        |
C     |COMPUTE THE SIMILARITY TRANSFORMATION USED IN REDUCTION |
C     |TO HESSENBERG FORM: ORIGINAL A = P TIMES HESSENBERG     |
C     |                MATRIX TIMES P INVERSE                  |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --OUTPUT FROM CHESS OR CAHESS            |
C     |                                                        |
C     |         LP    --LEADING (ROW) DIMENSION OF ARRAY P     |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         P     --SIMILARITY TRANSFORMATION              |
C     |                 (COMPLEX ARRAY)                        |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: CONJG                            |
C     |________________________________________________________|
C
      SUBROUTINE CSIM(P,LP,A)
      INTEGER H,I,J,K,L,LP,M,N
      COMPLEX A(1),P(LP,1),Z
      REAL T
      T = A(1)
      IF ( T .EQ. 2232 ) GOTO 10
      IF ( T .EQ. 2233 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST REDUCE MATRIX TO HESSENBERG FORM USING'
      WRITE(6,*) 'EITHER SUBROUTINE CHESS OR CAHESS BEFORE USING'
      WRITE(6,*) 'SUBROUTINE CSIM TO COMPUTE THE SIMILARITY'
      WRITE(6,*) 'TRANSFORMATION'
      STOP
10    N = A(2)
      P(1,1) = (1.,0.)
      IF ( N .EQ. 1 ) RETURN
      P(1,2) = (0.,0.)
      IF ( N .GT. 2 ) GOTO 20
      P(2,1) = (0.,0.)
      P(2,2) = (1.,0.)
      GOTO 120
20    L = N - 2
      M = N + 1
      H = 3
      DO 40 J = 1,L
           K = J + 1
           DO 30 I = K,N
30               P(I,J) = A(I+H)
40         H = H + M
      K = N
      M = N - 1
      Z = CONJG(P(K,L))
      P(N,N) = (1.,0.) - Z*P(N,L)
      P(M,N) = -Z*P(M,L)
60    J = M
      M = L
      L = L - 1
      IF ( L .EQ. 0 ) GOTO 90
      Z = (0.,0.)
      DO 70 I = J,N
70         Z = Z + CONJG(P(I,L))*P(I,K)
      P(M,K) = -Z*P(M,L)
      DO 80 I = J,N
80         P(I,K) = P(I,K) - Z*P(I,L)
      GOTO 60
90    P(1,K) = (0.,0.)
      K = K - 1
      M = K
      L = K - 1
      Z = -CONJG(P(K,L))
      DO 100 I = K,N
100         P(I,K) = Z*P(I,L)
      P(K,K) = (1.,0.) + P(K,K)
      IF ( L .GT. 1 ) GOTO 60
      DO 110 I = 2,N
110        P(I,1) = (0.,0.)
120   IF ( T .EQ. 2232 ) RETURN
      K = 1 + N + N*N
      DO 130 J = 1,N
           DO 130 I = 1,N
130             P(I,J) = A(I+K)*P(I,J)
      RETURN
      END
