C
C      ________________________________________________________
C     |                                                        |
C     |            INVERT AN UPPER HESSENBERG MATRIX           |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         A     --EFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         V     --INVERSE                                |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE EVERT(V,LV,A)
      REAL A(1),V(LV,1),T
      INTEGER I,J
      T = A(1)
      IF ( ABS(T) .EQ. 1237 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH EFACT BEFORE INVERTING'
      STOP
10    IF ( T .GT. 0. ) GOTO 20
      WRITE(6,*) 'ERROR: MATRIX HAS NO INVERSE'
      STOP
20    N = A(2)
      DO 40 J = 1,N
           DO 30 I = 1,N
30              V(I,J) = 0.
           V(J,J) = 1.
           CALL ESOLVE(V(1,J),A,V(1,J))
40    CONTINUE
      RETURN
      END
