C
C      ________________________________________________________
C     |                                                        |
C     |     FIND ALL THE EIGENVALUES OF A SYMMETRIC MATRIX     |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --COEFFICIENT MATRIX IN COMPRESSED FORMAT|
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --EIGENVALUES                            |
C     |                                                        |
C     |         D     --DIAGONAL OF REDUCED TRIDIAGONAL MATRIX |
C     |                                                        |
C     |         U     --SUPERDIAGONAL OF REDUCED MATRIX        |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: SHESS,TVALS                    |
C     |________________________________________________________|
C
      SUBROUTINE SVALS(E,D,U,A,N)
      REAL A(1),D(1),E(1),U(1),T
      INTEGER J,N
      CALL SHESS(D,U,A,N)
      J = 1 + (N*(N-1))/2
      T = A(J)
      CALL TVALS(E,U,D,U,N,A(J))
      A(J) = T
      RETURN
      END
