C      ________________________________________________________
C     |                                                        |
C     |        MULTIPLY A REAL BAND MATRIX BY A VECTOR         |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         X     --VECTOR                                 |
C     |                                                        |
C     |         A     --ARRAY CONTAINING BANDS OF COEFFICIENT  |
C     |                 MATRIX                                 |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         L     --NUMBER OF BANDS BELOW DIAGONAL         |
C     |                                                        |
C     |         U     --NUMBER OF BANDS ABOVE DIAGONAL         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         Y     --PRODUCT BETWEEN A AND X                |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: MIN0                             |
C     |________________________________________________________|
C
      SUBROUTINE BMULT(Y,X,A,LA,N,L,U)
      INTEGER I,J,K,L,LA,M,N,O,P,Q,U
      REAL A(LA,1),X(1),Y(1),T
      M = U + 1
      IF ( L .GT. 0. ) GOTO 30
      DO 20 J = 1,N
           T = 0.
           K = MIN0(N,J+U)
           M = M + 1
           DO 10 I = J,K
10              T = T + A(M-I,J)*X(I)
20         Y(J) = T
      RETURN
30    O = M
      P = N - 1
      DO 40 I = 1,P
40         Y(I) = 0.
      Y(N) = A(M,N)*X(N)
      DO 70 J = 1,P
           T = 0.
           K = MIN0(N,J+U)
           M = M + 1
           DO 50 I = J,K
50              T = T + A(M-I,J)*X(I)
           Y(J) = Y(J) + T
           K = J + 1
           Q = MIN0(N,J+L)
           O = O - 1
           T = X(J)
           DO 60 I = K,Q
60              Y(I) = Y(I) + A(O+I,J)*T
70    CONTINUE
      RETURN
      END
