C
C      ________________________________________________________
C     |                                                        |
C     |                  INVERT A BAND MATRIX                  |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         A     --BFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         V     --INVERSE                                |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE BVERT(V,LV,A)
      REAL A(1),V(LV,1),T
      INTEGER G,H,I,J,K,L,M,N,O,P,Q
      T = A(1)
      IF ( ABS(T) .EQ. 1231 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH BFACT BEFORE INVERTING'
      STOP
10    IF ( T .GT. 0. ) GOTO 20
      WRITE(6,*) 'ERROR: MATRIX HAS NO INVERSE'
      STOP
20    N = A(2)
      L = A(4)
      M = A(5)
      O = L + M
      M = 1 + L + O
      G = 5 - L - M
      DO 80 H = 1,N
           J = G + M*H
           K = H - 1
           Q = H
           DO 30 I = 1,N
30              V(I,H) = 0.
           V(H,H) = 1.
           IF ( L .GT. 0 ) GOTO 40
           K = N
           J = 5 - L + M*N
           IF ( M .GT. 1 ) GOTO 60
C     -------------------------
C     |*** DIAGONAL MATRIX ***|
C     -------------------------
           V(H,H) = V(H,H)/A(5+H+H)
           GOTO 80
C     -----------------------------
C     |*** FORWARD ELIMINATION ***|
C     -----------------------------
40         J = J + M
           I = A(J+K-O)
           K = Q
           Q = K + 1
           IF ( K .EQ. N ) GOTO 60
           T = V(I,H)
           V(I,H) = V(K,H)
           V(K,H) = T
           IF ( T .EQ. 0 ) GOTO 40
           P = MIN0(K+L,N)
           DO 50 I = Q,P
50              V(I,H) = V(I,H) - T*A(I+J)
           GOTO 40
C     --------------------------------------
C     |*** BACK SUBSTITUTION BY COLUMNS ***|
C     --------------------------------------
60         T = V(K,H)/A(J+K)
           V(K,H) = T
           IF ( K .EQ. 1 ) RETURN
           Q = MAX0(1,K-O)
           K = K - 1
           DO 70 I = Q,K
70              V(I,H) = V(I,H) - T*A(I+J)
           J = J - M
           GOTO 60
80    CONTINUE
      RETURN
      END
