C
C      ________________________________________________________
C     |                                                        |
C     |         DIAGONALIZE A COMPLEX HESSENBERG MATRIX        |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF COMPLEX     |
C     |                 ARRAY V                                |
C     |                                                        |
C     |         A     --COEFFICIENTS OF HESSENBERG MATRIX      |
C     |                 PACKED AT START OF COMPLEX ARRAY       |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |         W     --REAL WORK ARRAY WITH AT LEAST          |
C     |                 4N ELEMENTS                            |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --COMPLEX ARRAY OF EIGENVALUES           |
C     |                                                        |
C     |         V     --COMPLEX ARRAY OF EIGENVECTORS          |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: DAG                            |
C     |________________________________________________________|
C
      SUBROUTINE CEDIAG(E,V,LV,A,N,W)
      INTEGER I,J,L,LV,M,N
      COMPLEX A(1),E(1),V(LV,1)
      REAL W(1)
      DO 20 J = 1,N
           DO 10 I = 1,N
10              V(I,J) = 0.
20         V(J,J) = 1.
      M = N + 1
      L = M + N
      CALL DAG(E,V,LV,A,N,W,W(M),W(L))
      RETURN
      END
