C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE EIGENVECTOR CORRESPONDING TO GIVEN EIGENVALUE  |
C     |             FOR A GENERAL COMPLEX MATRIX               |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         E     --ESTIMATE OF EIGENVALUE                 |
C     |                 (COMPLEX VARIABLE)                     |
C     |                                                        |
C     |         V     --OUTPUT FROM EITHER SUBROUTINE CHESS,   |
C     |                 CAHESS, OR CVALS                       |
C     |                                                        |
C     |         W     --COMPLEX WORK ARRAY WITH AT LEAST       |
C     |                 N(N+9)/2 - 3 ELEMENTS                  |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --IMPROVED ESTIMATE FOR EIGENVALUE       |
C     |                                                        |
C     |         X     --COMPLEX ARRAY CONTAINING EIGENVECTOR   |
C     |                                                        |
C     |   BUILTIN FUNCTIONS: CONJG,REAL                        |
C     |   PACKAGE FUNCTIONS: MAG                               |
C     |   PACKAGE SUBROUTINES: CEVECT                          |
C     |________________________________________________________|
C
      SUBROUTINE CVECT(E,X,V,W)
      COMPLEX V(1),W(1),X(1),E,Z
      REAL S,T,MAG
      INTEGER H,I,J,K,L,M,N,O
      T = V(1)
      IF ( T .EQ. 2232 ) GOTO 10
      IF ( T .EQ. 2233 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST PROCESS THE COEFFICIENT MATRIX USING'
      WRITE(6,*) 'ONE OF THE FOLLOWING SUBROUTINES BEFORE COMPUTING'
      WRITE(6,*) 'AN EIGENVECTOR USING CVECT: CHESS, CAHESS, OR CVALS'
      STOP
10    N = V(2)
      IF ( N .GT. 1 ) GOTO 20
      E = V(3)
      X(1) = (1.,0.)
      RETURN
20    H = (N*(N+3))/2
      O = N + 1
      J = 2
      K = 1
      L = 2
      M = 1
C     --------------------------------------------------
C     |*** TRANSFER HESSENBERG MATRIX TO WORK ARRAY ***|
C     --------------------------------------------------
30    DO 40 I = M,L
40         W(I) = V(I+J)
      M = L + 1
      J = J + N - K
      K = K + 1
      L = M + K
      IF ( L .LT. H ) GOTO 30
      IF ( L .GT. H ) GOTO 50
      L = L - 1
      GOTO 30
50    CALL CEVECT(E,X,W,N)
      K = N
      J = 3 + (N-2)*O
C     -----------------------------------------------
C     |*** INVERT THE HOUSEHOLDER TRANSFORMATION ***|
C     -----------------------------------------------
60    J = J - O
      K = K - 1
      IF ( K .LE. 1 ) GOTO 90
      IF ( MAG(V(J+K)) .EQ. 0. ) GOTO 60
      Z = (0.,0.)
      DO 70 I = K,N
70         Z = Z + X(I)*CONJG(V(I+J))
      DO 80 I = K,N
80         X(I) = X(I) - Z*V(I+J)
      GOTO 60
90    IF ( REAL(V(1)) .EQ. 2232 ) GOTO 110
C     ---------------------------------------------
C     |*** INVERT THE BALANCING TRANSFORMATION ***|
C     ---------------------------------------------
      J = 1 + N*O
      DO 100 I = 1,N
100        X(I) = X(I)*V(I+J)
C     -----------------------------------
C     |*** NORMALIZE THE EIGENVECTOR ***|
C     -----------------------------------
110   S = 0.
      DO 120 I = 1,N
           T = MAG(X(I))
120        IF ( T .GT. S ) S = T
      IF ( S .NE. 0. ) S = 1./S
      DO 130 I = 1,N
130        X(I) = S*X(I)
      RETURN
      END
