C
C      ________________________________________________________
C     |                                                        |
C     |        APPROXIMATE THE SEMICONDUCTOR EQUATION          |
C     |               AT EVENLY SPACED POINTS                  |
C     |               ( CHAPTER 2 ALGORITHM )                  |
C     |________________________________________________________|
C
      REAL  NEW(50),OLD(50),D(53),U(50)
      REAL  S,T,DIF,SIZE
C                 -----------------------------------
C                 |*** INPUT NUMBER OF INTERVALS ***|
C                 -----------------------------------
10    READ(5,*) N
      IF ( N .LT. 2 ) STOP
      IF ( N .LT. 52 ) GOTO 30
      WRITE(6,20)
20    FORMAT(' ARRAY DIMENSION EXCEEDED')
      GOTO 10
C            ---------------------------------------------
C            |*** PREPROCESS AND INITIALIZE VARIABLES ***|
C            ---------------------------------------------
30    NM1 = N - 1
      S = N*N
      DO 40 I = 1,NM1
           OLD(I) = 0.
           D(I) = S + S
           U(I) = -S
40    CONTINUE
      CALL TFACT(U,D,U,NM1)
C                  --------------------------------
C                  |*** COMPUTE NEXT ITERATION ***|
C                  --------------------------------
50    DO 60 I = 1,NM1
           NEW(I) = EXP(-OLD(I))
60    CONTINUE
      CALL TSOLVE(NEW,U,D,U,NEW)
C                   -------------------------------
C                   |*** UPDATE AND TEST ERROR ***|
C                   -------------------------------
      CALL UPDATE(DIF,SIZE,NEW,OLD,NM1)
      CALL STOPIT(DIF,SIZE,4,100)
      IF ( DIF .GT. 0 ) GOTO 50
      CALL WHATIS(DIF,SIZE)
C                     --------------------------
C                     |*** PRINT THE ANSWER ***|
C                     --------------------------
      WRITE(6,70) N
70    FORMAT(I11,'  INTERVALS',/'      T               X(T)'/)
      DO 90 I = 1,NM1
           T = I/FLOAT(N)
           WRITE(6,80) T,NEW(I)
80         FORMAT(F10.5,F20.8)
90    CONTINUE
      WRITE(6,100)
100   FORMAT(//)
      GOTO 10
      END
