C      ________________________________________________________
C     |                                                        |
C     |     SOLVE A SYMMETRIC SYSTEM WITH PARTIAL PIVOTING     |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --IFACT'S OUTPUT                         |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION (CAN BE IDENTIFIED WITH B     |
C     |                 ALTHOUGH THE RIGHT SIDE IS DESTROYED)  |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |    PACKAGE SUBROUTINES: PSOLVE                         |
C     |________________________________________________________|
C
      SUBROUTINE ISOLVE(X,A,B)
      REAL A(1),B(1),X(1),T
      INTEGER I,J,K,L,M,N,O
      T = A(1)
      IF ( ABS(T) .EQ. 1237 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH IFACT BEFORE SOLVING'
      STOP
10    N = A(2)
      IF ( N .GT. 2 ) GOTO 20
      CALL PSOLVE(X,A(4),B)
      RETURN
20    O = 6 + (N*(N+5))/2
      M = N - 1
      IF ( T .LT. 0. ) GOTO 80
      DO 30 I = 1,N
30         X(I) = B(I)
      DO 40 K = 2,M
           J = A(K+O)
           T = X(J)
           X(J) = X(K)
40         X(K) = T
      K = 2
      I = 1
C     -----------------------------
C     |*** FORWARD ELIMINATION ***|
C     -----------------------------
50    T = X(K)
      K = K + 1
      IF ( T .EQ. 0. ) GOTO 70
      DO 60 J = K,N
60         X(J) = X(J) - T*A(I+J)
70    I = I + N - K
      IF ( K .LT. N ) GOTO 50
C     ---------------------------------
C     |*** SOLVE TRIDIAGONAL SYSTEM***|
C     ---------------------------------
80    I = 5 + (N*(N-3))/2
      CALL PSOLVE(X,A(I),X)
C     -----------------------------------
C     |*** BACK SUBSTITUTION BY ROWS ***|
C     -----------------------------------
      K = N
      J = M
      L = I - 1 - N
90    T = X(J)
      DO 100 I = K,N
100        T = T - X(I)*A(I+L)
      K = J
      X(K) = T
      J = J - 1
      L = L - N + K
      IF ( K .GT. 2 ) GOTO 90
      K = M
110   J = A(K+O)
      T = X(J)
      X(J) = X(K)
      X(K) = T
      K = K - 1
      IF ( K .GT. 1 ) GOTO 110
      RETURN
      END
