C
C      ________________________________________________________
C     |                                                        |
C     |                SOLVE A CIRCULANT SYSTEM                |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --EIGENVALUES COMPUTED BY OVALS          |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |         W     --COMPLEX WORK ARRAY WITH AT LEAST N     |
C     |                 ELEMENTS                               |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION (CAN BE IDENTIFIED WITH B     |
C     |                 ALTHOUGH THE RIGHT SIDE IS DESTROYED)  |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: CONJG                            |
C     |    PACKAGE SUBROUTINES: FFT                            |
C     |________________________________________________________|
C
      SUBROUTINE OSOLVE(X,A,N,B,W)
      COMPLEX A(1),B(1),W(1),X(1)
      REAL T
      T = N
      T = 1./T
      DO 10 I = 1,N
10         X(I) = T*CONJG(B(I))
      CALL FFT(X,N,W)
      DO 20 I = 1,N
20         X(I) = CONJG(X(I))/A(I)
      CALL FFT(X,N,W)
      RETURN
      END
