C      ________________________________________________________
C     |                                                        |
C     | COMPUTE THE DETERMINANT OF A FACTORED SYMMETRIC MATRIX |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --SFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         SDET,E--DETERMINANT IS SDET*10.**E (E INTEGER) |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,ALOG10,DLOG10                |
C     |________________________________________________________|
C
      FUNCTION SDET(E,A)
      REAL A(1),D,F,G
      DOUBLE PRECISION C
      INTEGER E,H,I,N
      D = A(1)
      IF ( ABS(D) .EQ. 1233 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH SFACT BEFORE',
     1'COMPUTING DETERMINANT'
      STOP
10    E = 0
      IF ( D .LT. 0. ) GOTO 80
      D = 1.
      F = 2.**64
      G = 1./F
      H = 64
      N = A(2)
      I = 4
20         D = D*A(I)
           I = I + N
           N = N - 1
           IF ( N .EQ. 0 ) GOTO 50
30         IF ( ABS(D) .LT. F ) GOTO 40
           E = E + H
           D = D*G
           GOTO 30
40         IF ( ABS(D) .GT. G ) GOTO 20
           E = E - H
           D = D*F
           GOTO 40
50    IF ( E .NE. 0 ) GOTO 60
      SDET = D
      RETURN
60    IF ( D .EQ. 0. ) GOTO 90
      C = ALOG10(ABS(D)) + E*DLOG10(2.D0)
      E = C
      C = C - E
      IF ( C .LE. 0.D0 ) GOTO 70
      C = C - 1
      E = E + 1
70    F = 10.**C
      IF ( D .LT. 0. ) F = -F
      SDET = F
      RETURN
80    SDET = 0.
      RETURN
90    E = 0
      GOTO 80
      END
