C
C      ________________________________________________________
C     |                                                        |
C     |COMPUTE THE SIMILARITY TRANSFORMATION USED IN REDUCTION |
C     |                   TO HESSENBERG FORM:                  |
C     | ORIGINAL A = P TIMES HESSENBERG MATRIX TIMES P INVERSE |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --OUTPUT FROM HESS OR AHESS              |
C     |                                                        |
C     |         LP    --LEADING (ROW) DIMENSION OF ARRAY P     |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         P     --SIMILARITY TRANSFORMATION              |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: HSR1                           |
C     |________________________________________________________|
C
      SUBROUTINE SIM(P,LP,A)
      REAL A(1),P(LP,1),T
      INTEGER H
      T = A(1)
      IF ( T .EQ. 2230 ) GOTO 10
      IF ( T .EQ. 2231 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST REDUCE MATRIX TO HESSENBERG FORM USING'
      WRITE(6,*) 'SUBROUTINE HESS BEFORE USING SUBROUTINE SIM TO'
      WRITE(6,*) 'COMPUTE THE SIMILARITY TRANSFORMATION'
      STOP
10    N = A(2)
      IF ( N .LE. 2 ) GOTO 40
      L = N - 2
      M = N + 1
      H = 3
      DO 30 J = 1,L
           K = J + 1
           DO 20 I = K,N
20               P(I,J) = A(I+H)
30         H = H + M
40    CALL HSR1(P,LP,N)
      IF ( T .EQ. 2230 ) RETURN
      K = 1 + N + N*N
      DO 50 J = 1,N
           DO 50 I = 1,N
50              P(I,J) = A(I+K)*P(I,J)
      RETURN
      END
