C      ________________________________________________________
C     |                                                        |
C     |        MULTIPLY A SYMMETRIC MATRIX BY A VECTOR         |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         X     --VECTOR                                 |
C     |                                                        |
C     |         A     --ARRAY PACKED WITH ELEMENTS CONTAINED IN|
C     |                 EACH ROW, ON DIAGONAL AND TO RIGHT, OF |
C     |                 COEFFICIENT MATRIX                     |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         Y     --PRODUCT BETWEEN A AND X                |
C     |________________________________________________________|
C
      SUBROUTINE SMULT(Y,X,A,N)
      REAL A(1),X(1),Y(1),R,S,T
      INTEGER I,J,K,L,N
      DO 10 I = 1,N
10         Y(I) = 0.
      K = 1
      L = 0
      IF ( N .EQ. 1 ) GOTO 40
      DO 30 J = 2,N
           T = X(K)
           S = A(K+L)*T
           DO 20 I = J,N
                R = A(I+L)
                S = S + R*X(I)
20              Y(I) = Y(I) + R*T
           Y(K) = Y(K) + S
           L = L + N - K
           K = J
30    CONTINUE
40    Y(N) = Y(N) + A(K+L)*X(N)
      RETURN
      END
