C
C      ________________________________________________________
C     |                                                        |
C     |  COMPUTE ALL THE EIGENVALUES OF A GENERAL REAL MATRIX  |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --REAL ARRAY CONTAINING MATRIX           |
C     |                 (LENGTH AT LEAST N(N+7) - 2)           |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --COMPLEX ARRAY OF EIGENVALUES           |
C     |                                                        |
C     |         V     --REAL ARRAY WITH AT LEAST 1+N(N+2)      |
C     |                 ELEMENTS USED AS INPUT FOR SUBROUTINE  |
C     |                 VECT WHEN EIGENVECTORS ARE COMPUTED    |
C     |                 (IF EIGENVECTORS ARE NOT DESIRED,      |
C     |                 ARGUMENT V CAN BE IDENTIFIED WITH A)   |
C     |                                                        |
C     |   BUILTIN FUNCTIONS: AIMAG,CONJG,REAL                  |
C     |   PACKAGE FUNCTIONS: MAG                               |
C     |   PACKAGE SUBROUTINES: AHESS,VLS                       |
C     |________________________________________________________|
C
      SUBROUTINE VALS(E,A,LA,N,V)
      REAL A(1),V(1),R,S,T,MAG
      COMPLEX E(1),Z
      INTEGER I,J,K,L,LA,M,N,O,P
      CALL AHESS(A,LA,N,E)
      O = N + 1
      P = N + 2
      L = 1 + N*P
      DO 10 I = 1,L
10         V(I) = A(I)
      IF ( N .GT. 1 ) GOTO 20
      E(1) = A(3)
      RETURN
20    IF ( N .GT. 2 ) GOTO 30
      A(1) = V(3)
      A(2) = 0.
      A(3) = V(4)
      A(4) = 0.
      A(5) = V(6)
      A(6) = 0.
      A(8) = 0.
      I = 9
      GOTO 80
30    J = 1
      K = N*N - 1
      M = 3
      L = 4
40    DO 50 I = M,L
           A(J) = V(I)
           A(J+1) = 0.
50         J = J + 2
      M = M + O
      L = L + P
      IF ( L .LT. K ) GOTO 40
      A(J) = A(M)
      A(J+1) = 0.
      J = J + 4*N
      M = M + O
      L = L + P
      I = J
60    L = L - 1
      J = J - 2
      A(J) = A(L)
      A(J+1) = 0.
      IF ( L .GT. M ) GOTO 60
      L = L - 1
      M = M - N
70    L = L - 1
      J = J - 2
      A(J) = A(L)
      A(J+1) = 0.
      IF ( L .GT. M ) GOTO 70
80    J = I + N
      K = J + N
      CALL VLS(E,A,N,A(I),A(J),A(K))
      I = O
90    I = I - 1
      IF ( I .LE. 1 ) GOTO 120
      Z = CONJG(E(I))
      R = ABS(AIMAG(Z))
      S = R
      L = I - 1
      DO 100 J = 1,L
           T = MAG(E(J)-Z)
           IF ( T .GE. S ) GOTO 100
           K = J
           S = T
100   CONTINUE
      IF ( R .GT. S ) GOTO 110
      E(I) = REAL(Z)
      GOTO 90
110   E(K) = E(L)
      E(L) = Z
      I = L
      GOTO 90
120   IF ( I .EQ. 1 ) E(I) = REAL(E(I))
      RETURN
      END
