C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE EIGENVECTOR CORRESPONDING TO GIVEN EIGENVALUE  |
C     |              FOR A GENERAL REAL MATRIX                 |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         E     --ESTIMATE OF EIGENVALUE                 |
C     |                 (COMPLEX VARIABLE)                     |
C     |                                                        |
C     |         V     --OUTPUT FROM EITHER SUBROUTINE HESS,    |
C     |                 AHESS, OR VALS                         |
C     |                                                        |
C     |         W     --WORK ARRAY WITH AT LEAST N(N+9)/2 - 3  |
C     |                 COMPLEX ELEMENTS IF AIMAG(E) .NE. 0.   |
C     |                 AND WITH AT LEAST N(N+9)/2 - 3 REAL    |
C     |                 ELEMENTS IF AIMAG(E) .EQ. 0.           |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --IMPROVED ESTIMATE FOR EIGENVALUE       |
C     |                                                        |
C     |         X     --COMPLEX ARRAY CONTAINING EIGENVECTOR   |
C     |                                                        |
C     |   BUILTIN FUNCTIONS: ABS,AIMAG,REAL                    |
C     |   PACKAGE SUBROUTINES: CEVECT,EVECT                    |
C     |________________________________________________________|
C
      SUBROUTINE VECT(E,X,V,W)
      COMPLEX E
      REAL V(1),W(1),X(1),R,S,T
      INTEGER I,J,K,L,M,N,O,P
      T = V(1)
      IF ( T .EQ. 2230 ) GOTO 10
      IF ( T .EQ. 2231 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST PROCESS THE COEFFICIENT MATRIX USING'
      WRITE(6,*) 'ONE OF THE FOLLOWING SUBROUTINES BEFORE COMPUTING'
      WRITE(6,*) 'AN EIGENVECTOR USING VECT: HESS, AHESS, OR VALS'
      STOP
10    N = V(2)
      IF ( N .GT. 1 ) GOTO 20
      E = V(3)
      X(1) = (1.,0.)
      RETURN
20    O = N + 1
      IF ( AIMAG(E) .NE. 0. ) GOTO 140
C     --------------------------------------------------
C     |*** TRANSFER HESSENBERG MATRIX TO WORK ARRAY ***|
C     --------------------------------------------------
      P = (N*(N+3))/2
      J = 2
      K = 1
      L = 2
      M = 1
30    DO 40 I = M,L
40         W(I) = V(I+J)
      M = L + 1
      J = J + N - K
      K = K + 1
      L = M + K
      IF ( L .LT. P ) GOTO 30
      L = L - 1
      IF ( L .LT. P ) GOTO 30
      T = REAL(E)
      CALL EVECT(T,X,W,N)
      E = T
      K = N
      J = 3 + (N-2)*O
C     -----------------------------------------------
C     |*** INVERT THE HOUSEHOLDER TRANSFORMATION ***|
C     -----------------------------------------------
60    J = J - O
      K = K - 1
      IF ( K .LE. 1 ) GOTO 90
      IF ( V(J+K) .EQ. 0. ) GOTO 60
      T = 0.
      DO 70 I = K,N
70         T = T + X(I)*V(I+J)
      DO 80 I = K,N
80         X(I) = X(I) - T*V(I+J)
      GOTO 60
90    IF ( V(1) .EQ. 2230 ) GOTO 110
C     ---------------------------------------------
C     |*** INVERT THE BALANCING TRANSFORMATION ***|
C     ---------------------------------------------
      J = 1 + N*O
      DO 100 I = 1,N
100        X(I) = X(I)*V(I+J)
C     -----------------------------------
C     |*** NORMALIZE THE EIGENVECTOR ***|
C     -----------------------------------
110   S = 0.
      DO 120 I = 1,N
           T = ABS(X(I))
120        IF ( T .GT. S ) S = T
      IF ( S .NE. 0. ) S = 1./S
      I = N + N
      J = N
130   X(I) = 0.
      X(I-1) = S*X(J)
      I = I - 2
      J = J - 1
      IF ( J .GT. 0 ) GOTO 130
      RETURN
C     --------------------------------------------------
C     |*** TRANSFER HESSENBERG MATRIX TO WORK ARRAY ***|
C     --------------------------------------------------
140   P = N + 2
      J = 1
      K = 2 + N*N
      M = 3
      L = 4
150   DO 160 I = M,L
           W(J) = V(I)
           W(J+1) = 0.
160        J = J + 2
      M = M + O
      L = L + P
      IF ( M .LT. K ) GOTO 150
      L = L - 1
      IF ( M .EQ. K ) GOTO 150
      CALL CEVECT(E,X,W,N)
      J = 1
      DO 170 I = 1,N
           W(I) = X(J)
           W(I+N) = X(J+1)
           J = J + 2
170   CONTINUE
      K = N
      J = 3 + (N-2)*O
C     -----------------------------------------------
C     |*** INVERT THE HOUSEHOLDER TRANSFORMATION ***|
C     -----------------------------------------------
180   J = J - O
      K = K - 1
      IF ( K .LE. 1 ) GOTO 210
      IF ( V(J+K) .EQ. 0. ) GOTO 180
      T = 0.
      S = 0.
      DO 190 I = K,N
           R = V(I+J)
           T = T + W(I)*R
190        S = S + W(I+N)*R
      DO 200 I = K,N
           R = V(I+J)
           L = I + N
           W(I) = W(I) - T*R
200        W(L) = W(L) - S*R
      GOTO 180
210   IF ( V(1) .EQ. 2230 ) GOTO 230
C     ---------------------------------------------
C     |*** INVERT THE BALANCING TRANSFORMATION ***|
C     ---------------------------------------------
      J = 1 + N*O
      DO 220 I = 1,N
           R = V(I+J)
           L = I + N
           W(I) = W(I)*R
220        W(L) = W(L)*R
C     -----------------------------------
C     |*** NORMALIZE THE EIGENVECTOR ***|
C     -----------------------------------
230   S = 0.
      DO 240 I = 1,N
           T = ABS(W(I)) + ABS(W(I+N))
240        IF ( T .GT. S ) S = T
      IF ( S .NE. 0. ) S = 1./S
      I = N + N
      J = N
250   X(I) = S*W(J+N)
      X(I-1) = S*W(J)
      I = I - 2
      J = J - 1
      IF ( J .GT. 0 ) GOTO 250
      RETURN
      END
