C
C      ________________________________________________________
C     |                                                        |
C     |    INVERT A TRIDIAGONAL MATRIX WITH PARTIAL PIVOTING   |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         A     --PFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         V     --INVERSE                                |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE PVERT(V,LV,A)
      REAL A(1),V(LV,1),S,T
      INTEGER I,J,K,L,N
      T = A(1)
      IF ( ABS(T) .EQ. 1235 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH PFACT BEFORE INVERTING'
      STOP
10    IF ( T .GT. 0. ) GOTO 20
      WRITE(6,*) 'ERROR: MATRIX HAS NO INVERSE'
      STOP
20    N = A(2)
      S = 2.**(-64)
      DO 110 L = 1,N
           IF ( L .GT. 1 ) GOTO 30
           V(L,L) = 1.
           J = L
           K = 3
           GOTO 60
30         J = L - 1
           K = 4*J - 1
           DO 40 I = 1,J
40              V(I,L) = 0.
           K = K + 4
           I = J
           J = J + 1
           V(J,L) = 1.
           IF ( A(K-3) .EQ. 0. ) GOTO 50
           T = V(J,L)
           V(J,L) = V(I,L)
           V(I,L) = T
50         V(J,L) = V(J,L) - A(K)*V(I,L)
C     -----------------------------
C     |*** FORWARD ELIMINATION ***|
C     -----------------------------
60         K = K + 4
           IF ( J .EQ. N ) GOTO 80
           I = J
           J = J + 1
           V(J,L) = 0.
           IF ( A(K-3) .EQ. 0. ) GOTO 70
           T = V(J,L)
           V(J,L) = V(I,L)
           V(I,L) = T
70         V(J,L) = V(J,L) - A(K)*V(I,L)
           GOTO 60
C     ---------------------------
C     |*** BACK SUBSTITUTION ***|
C     ---------------------------
80         K = K - 1
           V(J,L) = V(J,L)/A(K)
90         IF ( J .EQ. 1 ) GOTO 110
           J = J - 1
           K = K - 4
           V(J,L) = (V(J,L)-A(K-1)*V(J+1,L))/A(K)
100        IF ( J .EQ. 1 ) GOTO 110
           J = J - 1
           K = K - 4
           T = A(K-2)
           IF ( T .EQ. S ) T = 0.
           V(J,L) = (V(J,L)-A(K-1)*V(J+1,L)-T*V(J+2,L))/A(K)
           GOTO 100
110   CONTINUE
      RETURN
      END
