file=Makefile
echo "Extracting $file"
rm -f $file

file=Makefile.$osname-$arch$suffix
rm -f $file

if test -n "$GP_INSTALL_PREFIX"; then
  date=`date +%Y%m%d%H%M`; date="-t $date"
fi

case "$status" in
  alpha|beta) suf_status=".$status";;
  *) suf_status=;;
esac
tarfile=pari-$version.$patch$suf_status.tar

cat > $file << EOT
#
# This file was created by Configure. All changes made will be lost
# next time Configure is run.
#
SHELL = $make_sh
RM = /bin/rm -f

dft target::
	@echo "Possible targets are :"
	@echo "	gp			Compilation"
	@echo "	bench, test 		Compilation and test"
	@echo "	doc			Documentation"
	@echo "	install			Installation"
	@echo "For pari maintainers..."
	@echo "	all			Compile gp-sta gp-dyn lib-sta lib-dyn"
	@echo "	distrib			For distribution of pari/gp"
	@echo "	bigdistrib		Idem, with all directories"

gp all ftest bench test test-compat test-graphic install clean install-bin install-lib-sta install-bin-sta::
	cd $objdir; \$(MAKE) \$@

doc::
	cd doc; \$(MAKE)

RCS::
	cd src; ci -f -l -r\$\${REVISION:-$rcsrevision} -m"." */*.[chs]
	cd src; /bin/touch -m $date */*.[chs]

setdir::
	@dir=pari-$version.$patch$suf_status; if test -d \$\$dir; then \\
	   echo "Remove \$\$dir before building a new release"; exit 1;\\
	fi;\\
	mkdir \$\$dir; mv $tarfile \$\$dir; \\
	cd \$\$dir; tar xf $tarfile; \$(RM) $tarfile; cd ..; \\
	tar cf $tarfile \$\$dir; \\
	rm -r \$\$dir

bigdistrib: bigtar setdir
	gzip $tarfile

uu: bigdistrib
	uuencode $tarfile.gz $tarfile.gz > pari.uu

distrib: tar setdir
	gzip $tarfile

bigtar: tar
	tar rf $tarfile doc/gp.1 doc/tutorial.tex doc/app* doc/usersch* \
          doc/macros.tex.in doc/macrosbig.tex doc/Makefile.SOS doc/refcard.tex \
          doc/users.tex doc/users.help.tex

tar::
EOT
case "`tar 2>&1`" in
  *"--help"*) cat >> $file << EOT
	tar cfXT $tarfile $config_dir/tar_exclude $config_dir/tar_include
EOT
;;
  *) cat >> $file << EOT
	tar FcfX $tarfile $config_dir/tar_exclude -I $config_dir/tar_include
EOT
;;
esac

$ln_s $file Makefile 
