cat > doc/Makefile << EOT
#  This file was created by Configure. Any change made to it will be lost
#  next time configure is run.
#
SHELL = $make_sh

all: doc refcard tutorial

doc manual: users.dvi

tutorial: tutorial.dvi

tutorial.dvi: tutorial.tex
	tex tutorial.tex

refcard: refcard.ps

refcard.dvi: refcard.tex
	tex refcard.tex

refcard.ps: refcard.dvi
	dvips -t landscape -t a4 refcard.dvi -o

users.dvi: users.tex appa.tex appb.tex appc.tex appd.tex          \\
 usersch1.tex usersch2.tex usersch3.tex usersch4.tex usersch5.tex
	rm -f users.std; tex users;
	sed -e 's/!\([1-9]\)!/!00\1!/'     \\
	    -e 's/!\([1-9][0-9]\)!/!0\1!/' \\
	  users.idx | sort -f |            \\
	sed -e 's/!0*\([0-9]*\)!/!\1!/' > users.std;
	tex users; rm -f users.idx

halfclean:	
	rm -f *.log *.dvi *.idx *.ps tutorial.aux

clean: halfclean	
	rm -f users.aux users.std users.toc

veryclean: clean
	rm -f macros.tex 
EOT
