%                      Examples for the package crack
lisp(depl!*:=nil)$     % clearing of all dependences

write "1. An example for the decoupling "$
depend f,x,y$
setcrackflags()$
lisp(factorize_:=0)$
lisp(odesolve!_:=0)$
lisp(fcteval!_:=0)$
write crack({f+df(f,x)*df(f,y,y),df(f,y)+df(f,x)**2},{f},{x,y})$
nodepend f,x,y$

write "2. An example for the integration of exact PDEs"$
depend g,x$
depend f,x,y$
setcrackflags()$
lisp(genint_:=t)$
write crack({2*df(f,y)*df(g,x)+2*df(f,x,y)*g+g*df(g,x)**3+
       x*df(g,x)**4+3*x*g*df(g,x)**2*df(g,x,2)},{f,g},{x,y})$
nodepend g,x$
nodepend f,x,y$

write "3. An example for the generalized integration of PDEs"$
depend g,x$
depend f,x,y$
setcrackflags()$
lisp(genint_:=t)$
write crack({2*df(f,y)*df(g,x)+2*df(f,x,y)*g+g*df(g,x)**3+
       x*df(g,x)**4+3*x*g*df(g,x)**2*df(g,x,2)
       +g**2*(y**2+x*sin y+x**2*e**y)},{f,g},{x,y})$
nodepend g,x$
nodepend f,x,y$

write "4. An example for the indirect Separation"$
setcrackflags()$
lisp(genint_:=nil)$
lisp(factorize_:=8)$
depend f,x$
depend g,y$
write crack({y*f*g-x*y*df(f,x)/2-y*df(g,y)-(1+x**2)*y**2},{f,g},{x,y})$
nodepend f,x$
nodepend g,y$

write
"5. An example for the determination of point symmetries for ODEs"$
setcrackflags()$
depend y,x$
de := {df(y,x,2) = (df(y,x)*(2*x*y+x**3) - 4*y**2)/x**4, 
       y, x}$
mo := {0, {}, 1, 1}$
LIEORD(de,mo)$
nodepend y,x$

write "6. An example for the determination of first integrals of ODEs"$
setcrackflags()$
depend y,x$
de := {df(y,x,2)=x*df(y,x)**2-2*df(y,x)/x-y**2/x, y, x}$
mo := {0,{},2}$
FIRINT(de,mo)$
nodepend y,x$

write "7. An example for the determination of a Lagrangian for an ODE"$
setcrackflags()$
depend f,x$
depend y,x$
de := {df(y,x,2) = 6*y**2 + x, y, x}$
mo := {0,{}}$
LAGRAN(de,mo)$
nodepend f,x$
nodepend y,x$

write "8. An example for the factorization of an ODE"$
depend f,x$
depend y,x$
depend q,x$
setcrackflags()$
de := {df(y,x,2) = df(y,x)**2/y - f*df(y,x) - y*q, y, x}$
mo := {2,{}}$
DECOMP(de,mo)$
nodepend f,x$
nodepend y,x$
nodepend q,x$

end$

