;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   
;;;   This is the modified top level command loop for Macsyma
;;;   

(eval-when (compile) (macsyma-module continue))
(declare
   (special state-pdl errlist rephrase hist_list $inchar $linenum
	    poport st oldst writefilep mbreak linelable $% $outchar
	    $nolabels $lasttime **current-window** **replacement-string**))
(defun continue nil
   (let
      ;;; add 'macsyma-toplevel to the program state
      ((state-pdl (cons 'macsyma-toplevel state-pdl)))
      (prog
	 (
	    n			; current character read
	    test		; results of parsing and execution
	    pos		; cursor position save variable
	    $dispflag		; display flag for result
	    )
	 (setq errlist '((supunbind) (continue)))
	 (setq rephrase nil hist_list nil)

	 a2

	 (if (not (checklabel $inchar))
	     (setq $linenum (1+ $linenum)))

	 ;;; make the input line label

	 aa

	 (makelabel $inchar)

	 ;;; if the no io flag is on turn it off
	 ;;; and turn off the ttyoff flag

	 a1
	 ;;; changed from #.ttyoff
	 (if ^s (setq (eval ttyoff) nil ^s nil))

	 ;;; print a newline and then the label

	 (terpri)(printlabel)(drain poport)
	 (setq @select nil)

	 ;;; if rephrase is nil, we don't have to print
	 ;;; the input string again, so set it to nil
	 (cond((null rephrase)(setq st nil)(setq st (editor nil)))
		     (t (setq st (editor t))))
         ; reset the rephrase flag
	 (setq rephrase nil)
	 ;;; if the editor returned something
	 ;;; then set the display flag and strip
	 ;;; off the terminator

	 (cond((and st (equal (car st) #/;))
	       (setq n (car st) st (cdr st) $dispflag (= n #/;))))
	 d
	 ;;; if there's nothing on the command line except
	 ;;; the terminator, re-issue the same command line
	 ;;; number and get another command
	 ;;; a1
	 (cond ((null st)(go aa)))

	 (setq rephrase t oldst (cons n st))
	 (cond((member #/@ st)(show-status "Select expression with mouse")
               (setq @select t)
	       (do ()
		   ((plusp (get_buttons))) ())
	       (setq st
		     (strip (subst (append1
				      (reverse (append1 (mselect)
							'(41.)))
				      '(40.))
				   #/@ st)))
	       (clear-status)
	       (show-status "Executing..")
	       (setq **replacement-string**
		     (append1 (cons 40. (mstring (car 
		                (continue1 (car (parse1))))))
		         41.))
	       (setq st (reverse(select1)))
	       (clear-status)
	       ))
	 ;;; parse and execute
	 ;;; if parse says the command was no good,
	 ;;; it has already taken care of notifying
	 ;;; the user, so go get another command
	 (unless @select (show-status '|Parsing Input|))
	 (cond ((null (setq test (parse1)))
		(setq st (reverse st))(clear-status)(go aa)))
	 (unless @select (clear-status))
	 ;;; if continue1 returns null, it got interrupted,
	 ;;; had a problem with time or space, or blew up
	 ;;; trying to process the command, even though
	 ;;; parse said it was ok.  so go print the same
	 ;;; command line prompt
	 (show-status '|Executing....|)
	 (cond   ((null (setq test (continue1 (car test))))
		  (cond (mbreak (clear-status)(errlfun1 mbreak))
			(t (clear-status)
			   (errlfun t)
			   (setq st (reverse st))
			   (go a2)))
		  (clear-status))
		 ;;; save the input string, as a property
		 ;;; of the linelabel so that we'll be able
		 ;;; to edit and re-execute it later without
		 ;;; mstringing it

		 (t (clear-status)

		    ;;; save the general form

		    (setq $% (car test))

		    ;;; make the output linelabel

		    (makelabel $outchar)

		    ;;; if a label was made,
		    ;;; point it at the general form
		    ;;; and putprop the times on it

		    (when (not $nolabels)
			  (set linelable $%)
			  (putprop linelable
				   (cons (cadr $lasttime)(caddr $lasttime))
				   'time))
		    (setq rephrase nil)

		    ;;; if the display flag is set,
		    ;;; remove the nodisplay property
		    ;;; and call display

		    (cond ($dispflag  (remprop linelable 'nodisp)
				      (show-status '| Displaying Result |)
				      (display*)
				      (clear-status))
			  (t (putprop linelable t 'nodisp)))

		    ;;; increment the linenumber

		    (setq $linenum (1+ $linenum))))

	 ;;; get another command

	 (go aa))))
;;;   
;;;   send an expression directly to displa
;;;   

(defun inject (s)
      (setq $% s )
      (makelabel $outchar)
	(when (not $nolabels)
           (set linelable $%)
	      (putprop linelable
	  (cons (cadr $lasttime)(caddr $lasttime))
		  'time))
		(cond ((neq **current-window** 'plot)
		         (remprop linelable 'nodisp)
				  (display*))
			      (t (putprop linelable t 'nodisp)))
			
			;;; increment the linenumber
			
			(setq $linenum (1+ $linenum)))

