;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This file contains the code for generating output, given the
;;; drawing instructions from the displa module. 
(eval-when (compile)(macsyma-module output))

(eval-when (compile) (require  '//user//vaxima//young//devdep//gelib))
(declare
     (macros t)
     (special bkpt bkptwd bkptht bkptdp bkptout maxht maxdp break
           $outchar **str** old-row **oldcol** **current-window**
	   $linenum lg-character-x lg-character-y lg-character-x-2 
	   lg-character-y-2 lg-old-x lg-old-y ttyheight linel $linel))
(load '//user//vaxima//young//displa//macros)
(defun output (result w)
   (putprop (makelabel $outchar) (reverse result) 'outform)
    (declare (fixnum w))
	 (output-2d (nreverse result) w))

(defun output-2d (result w &aux h)
   (setq **str** nil)
   (declare (fixnum w h ch))
   ;;; read the cursor position and set oldrow to y+1, **oldcol** to 0
   ;;; and h to the y position of the end of the expression
   ;;;
   (setq old-row  (car (cursorpos))
	 **oldcol** 0
	 h (+ old-row bkptht bkptdp))
   ;;;
   ;;; check for the end of the screen, go back to the top if we're over
   ;;;
   (cond((<= ttyheight (+ 2 h))
	 (setq h (- h old-row))
	 (putprop  **current-window**
		   (remove-end-window (get **current-window** 'd-lines)
				      (* lg-character-y old-row))  'd-lines)
	 ;;;
	 ;;; move to the top of the screen
	 ;;;
	 (setq old-row 0 )
	 (cursorpos 0 0)
	 ))
   ;;;
   ;;; add the line label and it's y extent to the window-table
   ;;;
   (putprop **current-window**
	    (update-window  (get **current-window** 'd-lines)
			    (* lg-character-y old-row)
			    (* lg-character-y  h))   'd-lines)
   ;;;
   ;;;   move to bottom of expression
   ;;;
   (setq old-row h)
   (cursorpos old-row 0)
   ;;;
   ;;;   draw it
   ;;;
   (draw-2d result (- old-row bkptdp 1) w)
   ;;;
   ;;;   move to the next location
   ;;;
   (cond((not super)(cursorpos (1+ h) 0))
	      (t(cursorpos old-row **oldcol**)))
   ;;;
   ;;;   store the expression as a property of the d line
   ;;;
   (cond((get (concat $outchar $linenum) 'exp)
	 (putprop (concat (stripdollar $outchar) $linenum)
		  (append **str**
			  (get (concat (stripdollar $outchar) $linenum)
			       'exp))  'exp))
	      (t(putprop (concat (stripdollar $outchar) $linenum) **str** 'exp)))
   )



(defun draw-2d (dmstr row col)
   (declare (fixnum row col))
   (cursorpos row col) 	
   (do ((l dmstr)) ((null l))
       ;;;
       ;;; if car of l is simply a fixnum (representing a character)
       ;;; output it, adding it and it's location to the **str**
       ;;;
       (cond ((fixp (car l))
	      (tyo* (car l))
	      (cond((not(= 32. (car l)))
		    (setq **str** (list*
				     (list
					(* lg-character-x col)
					(* lg-character-x (1+ col))
					(* lg-character-y row)
					(* lg-character-y (1+ row))
					(car l)) **str**))))
	      (setq col (1+ col))
	      (pop l))
	     ;;;
	     ;;; else if the caar of l is a fixnum then we have a list
	     ;;; with an x,y offset first
	     ;;;
	     ((fixp (caar l))
	      (setq col **oldcol**)
	      (do () ((or (fixp (car l)) (not (fixp (caar l)))))
		  (cond((null (cddar l)) (setq col (+ col (caar l))))
			      (t(setq **str** (list* '(begin-list) **str**))
				      (draw-2d (reverse (cddar l))
					       (-  row (cadar l)) (+ col (caar l)))
				      (setq **str** (list* '(end-list) **str**))
				      (setq col **oldcol**)))
		  (pop l))
	      (cursorpos row col)) 
	     ;;;
	     ;;; if it's an end-of -function marker, ignore it
	     ;;;
	     ((or (= 'begin-list (caar l))
		  (= (caar l) 'end-deriv)
		  (= (caar l) 'end-list))
	      (setq **str** (list* (car l) **str**))(pop l))
	     ;;;
	     ;;; if it's a drawing function, draw it. the drawing function
	     ;;; must add the actual location to the **str**
	     ;;;
	     (t(lexpr-funcall (caar l)  (cdar l))
			      (pop l)))))


(declare (*expr lg-set-point lg-draw-vector lg-end-vector)
	 (notype (lg-set-point fixnum fixnum)
		 (lg-draw-vector fixnum fixnum)
		 (lg-end-vector fixnum fixnum))
	 (special lg-character-x lg-character-x-2
		  lg-character-y lg-character-y-2)
)

;;;   
;;;   
;;;   
(progn 'compile
(declare (special lg-old-x lg-old-y))
(defun lg-end-vector (x y)
   (lg-draw-vector x y))

(defun lg-set-point (x y)
    (setq lg-old-x x
	  lg-old-y  y
    ))
)

(defun d-hbar (w)
   (declare (fixnum w char gy))
   (let ((gy (+ (* lg-character-y old-row) lg-character-y-2 2)))
      (lg-set-point  (* **oldcol** lg-character-x) gy)
      (lg-end-vector  (* (+ **oldcol** w) lg-character-x) gy)
      (setq **str** (list* (list (* **oldcol** lg-character-x)
				 (* (+ **oldcol** w) lg-character-x)
				 (* old-row lg-character-y)
				 (*  (1+ old-row) lg-character-y)
				 'd-hbar) **str**))
      (cursorpos old-row (+ **oldcol** w)))) 


   (defun d-vbar-r (h d)
	  (declare (fixnum h d char gx))
	  (let ((gx (+ (* lg-character-x **oldcol**) lg-character-x-2)))
	     (lg-set-point  gx (- (* (+ old-row d 1) lg-character-y) 2))
	     (lg-end-vector gx (+ (* (+ old-row 1 (- h)) lg-character-y) 2)))
	  (setq **str** (list* (list
				  (-(* lg-character-x **oldcol**)
				       lg-character-x-2)
				  (+(* lg-character-x **oldcol**)
				       lg-character-x-2)
				  (+(*(+ old-row 1 (-  h)) lg-character-y) 2)
				  (-(*(+ old-row 1 d) lg-character-y)2)
				  'd-vbar-r) **str**))
	  )

   (defun d-vbar-l (h d)
	  (declare (fixnum h d char gx))
	  (let ((gx (- (* lg-character-x **oldcol**) lg-character-x-2)))
	     (lg-set-point  gx (- (* (+ old-row d 1) lg-character-y) 2))
	     (lg-end-vector gx (+ (* (+ old-row 1 (- h)) lg-character-y) 2)))
	  (setq **str** (list* (list
				  (-(* lg-character-x **oldcol**)
				       lg-character-x-2)
				  (+(* lg-character-x **oldcol**)
				       lg-character-x-2)
				  (+(*(+ old-row 1 (-  h)) lg-character-y) 2)
				  (-(*(+ old-row 1 d) lg-character-y)2)
				  'd-vbar-l) **str**))
	  )


   (defun d-prodsign ()
	  (declare (fixnum x2 y2 x3 y3 x4 y4 x5 y5 x7 y7 x8 y8 x3a x4a))
	  (setq x2 (* lg-character-x (1- **oldcol**))
		y2 (-(* lg-character-y (1- old-row )) lg-character-y-2)
		x3 (* lg-character-x  **oldcol** ) y3 y2
		x4 (* lg-character-x (+ **oldcol** 3)) y4 y2
		x5 (* lg-character-x (+ 4 **oldcol**)) y5 y2
		x7 x3 y7 (+(* lg-character-y (+ old-row 1))lg-character-y-2)
		x8 x4 y8 y7
		x3a (+ x3 lg-character-x-2)
		x4a (- x4 lg-character-x-2))
	  (setq **str** (list* (list x2 x5 y2 y8 'd-prod)
			       **str**))
	  ; top
	  (lg-set-point x2 y2)
	  (lg-draw-vector x5 y5)
	  (lg-set-point x2 y2)
	  (lg-draw-vector x3 (1+ y2))
	  (lg-draw-vector x4a (1+ y2))
	  (lg-end-vector x5 y5)
	  ; bottom
	  (lg-set-point x2 y8)
	  (lg-draw-vector x5 y8)
	  (lg-set-point x2 y8)
	  (lg-draw-vector x3 (1- y8))
	  (lg-draw-vector x4a (1- y8))
	  (lg-end-vector x5 y8)
	  ; left col
	  (prog (xx)
	     (setq xx x3)
	     loop1
	     (increment xx)
	     (cond((> xx x3a)(return nil)))
	     (lg-set-point xx y3)
	     (lg-draw-vector xx y7)
	     (go loop1))

	  ; right col
	  (prog (xx)
	     (setq xx x4a)
	     loop1
	     (increment xx)
	     (cond((> xx x4)(return nil)))
	     (lg-set-point xx y3)
	     (lg-draw-vector xx y7)
	     (go loop1))
	  )

   (defun d-sumsign ()
	  (declare (fixnum x-min x-half x-max y-min y-half y-max))
	  (let ((x-min  (* lg-character-x **oldcol**))
		(x-half (* lg-character-x (+ **oldcol** 2)))
		(x-max  (* lg-character-x (+ **oldcol** 4)))
		(y-min  (+ (* lg-character-y (- old-row 2)) lg-character-y-2))
		(y-half (+ (* lg-character-y old-row) lg-character-y-2))
		(y-max  (+ (* lg-character-y (+ old-row 2)) lg-character-y-2))
		)
	     (setq **str** (list* (list x-min
					(+ x-max 4)
					y-min
					y-max
					'd-sumsign)
				  **str**))
	     (lg-set-point (+ x-max 4) (+ y-min 6))
	     (mapc #'(lambda (x) (lg-draw-vector (car x) (cdr x)))
		    `((,x-max . ,y-min)
		      (,(1+ x-min)  . ,y-min)
		      (,(1+ x-half) . ,y-half)
		      (,(1+ x-min)  . ,y-max)
		      (,x-min	    . ,y-max)
		      (,x-half	    . ,y-half)
		      (,x-min	    . ,y-min)
		      (,(1- x-min)  . ,y-min)
		      (,(1- x-half) . ,y-half)))
	     (lg-set-point (+ x-max 4) (- y-max 6))
	     (lg-draw-vector x-max y-max)
	     (lg-draw-vector x-min y-max)
	     (lg-set-point (+ x-min 2)  y-min )
	     (lg-end-vector (+ x-half 2) y-half)
	     (lg-set-point (1+ x-min) (- y-max 2))
	     (lg-end-vector x-max (- y-max 2))
	     (lg-set-point x-min (1- y-max))
	     (lg-end-vector x-max (1- y-max)))
	  )



   (defun d-matrix ( direction h d mrow mcol)
	  (declare (fixnum h d x-min x-max y-min y-max))
	  (let ((x-min (1+ (* lg-character-x **oldcol**)))
		(x-max (1- (* lg-character-x (1+ **oldcol**))))
		(y-min (+ (* lg-character-y (+ old-row 1 (- h))) 2))
		(y-max (- (* lg-character-y (+ old-row 1 d)) 2)))
	     (if (eq direction 'right) 
	         then (setq tempx x-min)(setq x-min x-max)
		     (setq x-max tempx))
	     (if (eq direction 'right)
		 (setq **str** (list*
				  (list  x-max
					 (+ x-min lg-character-x)
					 y-min
					 y-max
					 'd-matrix-r mrow mcol)
				  **str**))
		 (setq **str** (list*
				  (list (- x-min lg-character-x-2)
					x-max y-min y-max
					'd-matrix-l mrow mcol)
				  **str**)))
	     (lg-set-point   x-max y-min)
	     (lg-draw-vector x-min y-min)
	     (lg-draw-vector x-min y-max)
	     (lg-end-vector  x-max y-max))
	  )



   ;;;----------------------------------------------------------
   ;;; function to draw a subscript- works by setting the character size
   ;;;
   ;;;----------------------------------------------------------
   (defun d-subscrip ( x y &rest str)
	  (declare (fixnum y x))
	  (setq **str** (list* (list (-(*(+  x **oldcol**)
					     lg-character-x) lg-character-x-2)
				     (+(*(+  x **oldcol**)
					     lg-character-x)lg-character-x-2)
				     (-(*(- old-row  y)
					    lg-character-y) 2)
				     (+ (* (- old-row y)
					   lg-character-y) 2)
				     'd-subscript) **str**))
	  (increment superlevel)
	  (setq **str** (list* (list 'begin-list) **str**))
	  (draw-2d (nreverse str) (- old-row y) (plus  x **oldcol**))
	  (setq **str** (list* (list 'end-list) **str**))
	  (setq superlevel (1- superlevel))
	  (cursorpos (1- old-row) **oldcol**) ;  was cursorp
	  ;    (cond((eq superlevel -1)(big_char)
		     ;	 ))
	  )
   ;;;----------------------------------------------------------------
   ;;; function to draw an exponent- works by setting the character size
   ;;; and setting global line spacing flags the actual drawing is done
   ;;; by draw-2d
   ;;;-----------------------------------------------------------------
   (defun d-super (x y &rest str)
	  (declare (fixnum x y))
	  (setq **str** (list* (list 'begin-list)
			       (list (-(*(+ 1 x **oldcol**)
					    lg-character-x) lg-character-x-2)
				     (+(*(+ 1 x **oldcol**)
					    lg-character-x)lg-character-x-2)
				     (+(*(- old-row y)
					    lg-character-y)lg-character-y-2)
				     (+(* old-row
					  lg-character-y)lg-character-y-2)
				     'd-super)  **str**))
	  (increment superlevel)
	  (draw-2d (nreverse str) (- old-row y) (plus  x **oldcol**))
	  (setq **str** (list* (list 'end-list) **str**))
	  (setq superlevel (1- superlevel))
	  (cursorpos (1+ old-row) **oldcol**) 
	  )
   ;;;-----------------------------------------------------------------
   ;;; d-derivative:
   ;;;----------------------------------------------------------------
   (defun d-deriv (x y z &rest str)
	  (declare (fixnum x y z))
	  (setq **str** (list* (list 'begin-list)
			       (list (* **oldcol** lg-character-x)
				     (* (+ 1 **oldcol**)
					lg-character-x)
				     (* old-row
					lg-character-y)
				     (* ( 1+ old-row)
					lg-character-y)
				     'd-deriv)  **str**))
	  )


   ;;;----------------------------------------------------------------
   ;;; draw the sqrt figure
   ;;;----------------------------------------------------------------
   (defun d-sqrt ( h d w )
	  (prog (x1 x2 x3 x4 x5 y1 y2 y3 y4 y5)
	     (declare (fixnum x1 x2 x3 x4 x5 y1 y2 y3 y4 y5))
	     ;;;
	     ;;; if the sqrt root is of a single atom
	     ;;;
	     (cond((= 1 w)
		   (setq x1 (fix(times lg-character-x
				       (diff **oldcol** 0.4 (times 0.16 w))))
			 y1 (fix(times lg-character-y
				       (diff (1+ old-row) (times 0.5 h))))
			 x2 (fix(times lg-character-x
				       (diff **oldcol** 0.3 (times 0.08 w))))
			 y2 (fix(times lg-character-y
				       (diff (1+ old-row) (times 0.75 h))))
			 x3 (times lg-character-x  **oldcol**)
			 y3 (times (plus old-row 1 d) lg-character-y)
			 x4 (fix (times lg-character-x
					(plus **oldcol** (times 0.08 w))))
			 y4  (fix(times lg-character-y
					(diff (plus 0.8 old-row) h)))
			 x5 (times lg-character-x (+ **oldcol** w ))
			 y5 y4)
		   (setq **str** (list* (list x1 x4 y5 y3 'd-sqrt) **str**))
		   (lg-set-point (- x1 2) y1 )
		   (lg-draw-vector (- x2 2) y2 )
		   (lg-draw-vector (- x3 2) y3 )
		   (lg-draw-vector (- x4 2) y4 )
		   (lg-end-vector x5 y5)
		   )
		      ;;;
		      ;;; else if the sqrt is of a more complicated figure
		      ;;; use this
		      ;;;
		      (t(setq x1 (fix(times lg-character-x
					    (diff **oldcol** 1 (times 0.16
								      (min w 10)))))
			      y1 (fix(times lg-character-y
					    (diff (1+ old-row) (times 0.25
									 (min h 5)))))
			      x2 (fix(times lg-character-x
					    (diff **oldcol** 1 (times 0.08
								      (min w 10)))))
			      y2 (fix(times lg-character-y
					    (diff (1+ old-row) (times 0.50
									 (min h 5)))))
			      x3 (times lg-character-x (1- **oldcol**))
			      y3 (1- (* (+ old-row 1 d) lg-character-y))
			      x4 (fix (times lg-character-x
					     (plus (1- **oldcol**) (times 0.08
									  (min w 10)))))
			      y4  (fix(times lg-character-y
					     (diff (plus 0.8 old-row) h)))
			      x5 (times lg-character-x (+ **oldcol** w ))
			      y5 y4)
			      (setq **str** (list* (list x1 x4 y5 y3 'd-sqrt) **str**))
			      (lg-set-point x1 y1 )
			      (lg-draw-vector x2 y2 )
			      (lg-draw-vector x3 y3 )
			      (lg-draw-vector x4 y4 )
			      (lg-end-vector x5 y5)
			      (lg-set-point (1+ x2) y2)
			      (lg-end-vector (1+ x3) y3)
			      )
		      )
	     )
	  )


   ;;;------------------------------------------------------------------
   ;;;   function to draw the integral sign-- variable size depending
   ;;;   on the height and depth of the integrand
   ;;;------------------------------------------------------------------
   (defun d-integralsign ( h d type &aux dmstr)
	  (declare (fixnum x-mid x1 x2 x-max y-mid y1 y2 y-max hh))
	  (setq hh (//(+ d h) 2))
	  ;;;
	  ;;; set the points
	  ;;;
	  (setq x-mid (* lg-character-x  **oldcol**)
		y-mid (* lg-character-y old-row)
		y1 (* lg-character-y (- old-row hh))
		y2 (* lg-character-y (+ old-row hh))
		x1 (+ x-mid (// (- y-mid y1) 4))
		x2 (- x-mid (// (- y-mid y1) 4))
		x3 (+ x1  (// (- y-mid y1) 8))
		x4 (- x2  (// (- y-mid y1) 8))
		)

	  (cond((= type 1)
		(setq **str** (list*
				 (list   x4 x3 (- y1 2 );(* lg-character-y 2))
				 (+ 4 y2); (* lg-character-y 2))
		      'd-integral1)
		**str**)))
   (t(setq **str** (list*
		      (list   x4 x3 (- y1 2); lg-character-y)
		      (+ 2 y2); (* lg-character-y 2))
	   'd-integral2)
	   **str**))))
    ;;;
    ;;;   draw the integral sign end points
    ;;;
    
    (lg-set-point x1 y1)
    (lg-end-vector  x3 (1- y1))
    (lg-set-point x1 y1)
    (lg-end-vector  (1- x3) (- y1 2))
    (lg-set-point x1 y1)
    (lg-end-vector x3 y1)
    (lg-set-point x1 y1)
    (lg-end-vector  x3 (1+ y1))
    (lg-set-point x1 y1)
    (lg-end-vector  (1- x3)  (+ 2 y1))
    (lg-set-point x1 y1)
    (lg-end-vector (- x3 2) (1+ y1))
    ;;;
    (lg-set-point x2 y2)
    (lg-end-vector  x4 (1+ y2))
    (lg-set-point x2 y2)
    (lg-end-vector  (1+ x4) (+ y2 2))
    (lg-set-point x2 y2)
    (lg-end-vector x4 y2)
    (lg-set-point x2 y2)
    (lg-end-vector  x4 (1- y2))
    (lg-set-point x2 y2)
    (lg-end-vector  (1+ x4)  (-  y2 2))
    (lg-set-point x2 y2)
    (lg-end-vector (+ x4 2) (1- y2))
    ;;; draw stem
    (lg-set-point x1 y1)
    (lg-draw-vector x-mid y-mid)
    (lg-end-vector x2 y2)
    (lg-set-point x1 y1)
    (lg-draw-vector (1- x-mid) y-mid)
    (lg-end-vector x2 y2)
    (lg-set-point x1 y1)
    (lg-draw-vector (1+ x-mid) y-mid)
    (lg-end-vector x2 y2)
    (lg-set-point x1 y1)
    (lg-draw-vector (+ x-mid 2) y-mid)
    (lg-end-vector x2 y2)
)
;;;----------------------------------------------------------------
;;; draw a left parenthesis -- size variable
;;;----------------------------------------------------------------
(defun d-paren-l (  h d)
   ;;;
   ;;; if the height is less than 2, use a regular sized parenthesis
   ;;;
   (cond((>= 2 (+ h d))
	 (setq **str** (list* (list 'begin-list)
			      (list (* **oldcol** lg-character-x)
				    (* (1+ **oldcol**) lg-character-x)
				    (* old-row lg-character-y)
				    (* (1+ old-row) lg-character-y)
				    'l-paren)
			      **str**))
	 (tyo* 40. )
	 (cursorpos old-row (1- **oldcol**)) 
	 )
	     ;;;
	     ;;;  else figure out the height and vector-draw a paren
	     ;;;
	     (t(setq hh (// (* lg-character-y (+ h d)) 2))
		     (setq x1 (-(+ (* **oldcol** lg-character-x)
				   (* h lg-character-x-2)) 2))
		     (setq y1   (- (*  (1+ old-row) lg-character-y) hh))
		     (setq x3 (* **oldcol** lg-character-x))
		     (setq y3   (* (1+ old-row) lg-character-y))
		     (setq y2 (// (+ y1 y3) 2 ))
		     (setq x2 (// (+ x1 (- x3 lg-character-x-2)) 2))
		     (setq x4 (* **oldcol** lg-character-x))
		     (setq y4   (* (+ 2 old-row) lg-character-y))
		     (setq x6  x1)
		     (setq y6   (+ (* (+ 2 old-row) lg-character-y) hh))
		     (setq y5 (// (+ y4 y6) 2 ))
		     (setq x5 x2)
		     (setq **str** (list* (list 'begin-list)
					  (list x3 x1 y1 y6 'l-paren)
					  **str**))
		     (lg-set-point x1 y1)
		     (lg-draw-vector x2 y2)
		     (lg-draw-vector x3 y3)
		     (lg-draw-vector x4 y4)
		     (lg-draw-vector x5 y5)
		     (lg-end-vector x6 y6)
		     (cursorpos old-row **oldcol**)
		     )))
;;;----------------------------------------------------------------
;;; draw a left parenthesis -- size variable
;;;----------------------------------------------------------------
(defun d-paren-r ( h d)
   (cond((>= 2 (+ h d))
	 (setq **str** (list*
			  (list (* **oldcol** lg-character-x)
				(* (1+ **oldcol**) lg-character-x)
				(* old-row lg-character-y)
				(* (1+ old-row) lg-character-y)
				'r-paren)
			  (list 'end-list)
			  **str**))
	 (tyo* 41. )
	 (cursorpos old-row (1- **oldcol**))
	 )
	     ;;;
	     ;;; vector draw a large paren
	     ;;;
	     (t(setq hh(// (* lg-character-y (+ h d)) 2))
		     (setq y1 (- (*  (1+ old-row) lg-character-y) hh))
		     (setq x1 (+(* **oldcol** lg-character-x) 2))
		     (setq x3 (+ (* **oldcol** lg-character-x)
				 (* h lg-character-x-2)))
		     (setq y3   (* (1+ old-row) lg-character-y))
		     (setq y2 (// (+ y1 y3) 2 ))
		     (setq x2 (// (+ x1 (+ x3 lg-character-x-2)) 2))
		     (setq x4  x3)
		     (setq y4   (* (+ 2 old-row) lg-character-y))
		     (setq x6 x1)
		     (setq y6   (+ (* (+ 2 old-row ) lg-character-y) hh))
		     (setq y5 (// (+ y4 y6) 2 ))
		     (setq x5 x2)
		     (setq **str** (list* (list x1 x3 y1 y6 'r-paren)
					  (list 'end-list)
					  **str**))
		     (lg-set-point x1 y1)
		     (lg-draw-vector x2 y2)
		     (lg-draw-vector x3 y3)
		     (lg-draw-vector x4 y4)
		     (lg-draw-vector x5 y5)
		     (lg-end-vector x6 y6)
		     (cursorpos old-row **oldcol**) 
		     )))

;;;---------------------------------------------------------------
;;; d-del : draw a delta for a single differential
;;;--------------------------------------------------------------
(defun d-del (dummy)
   (setq **str** (list*
		    (list (* **oldcol** lg-character-x)
			  (* (1+ **oldcol**) lg-character-x)
			  (* old-row lg-character-y)
			  (* (1+ old-row) lg-character-y)
			  'd-del)
		    **str**))

   (tyo* 200.)
   (cursorpos old-row **oldcol**))

;;;-----------------------------------------------------------------
;;; d-deriv : is just for the data base, the actual drawing is done
;;; by dratio
;;;-----------------------------------------------------------------
(defun d-deriv ( w h d &rest remform)
   (setq **str** (list*
		    (append (list (* **oldcol** lg-character-x)
				  (* (+ w **oldcol**) lg-character-x)
				  (* (- old-row h) lg-character-y)
				  (* (+ old-row d) lg-character-y)
				  'd-deriv) remform)
		    **str**)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: CURSORPOS
;;;   
;;;      Purpose:  Move the cursor to r,c
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Feb 01 23:32:27 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cursorpos  (&optional r c)
   (cond(r (setq old-row r **oldcol** c)))
   (list old-row **oldcol**)
   )


(defun lg-draw-vector (x y)
   (draw_line (+ (rect->x (get **current-window** 'screenrect)) lg-old-x)
	      (+ (rect->y (get **current-window** 'screenrect)) lg-old-y)
	      (+ (rect->x (get **current-window** 'screenrect))  x)
	      (+ (rect->y (get **current-window** 'screenrect)) y))
   (setq lg-old-x x lg-old-y y))


(defun tyo* (char)

   (declare (fixnum char))
   (cond((equal char #/*))
		(t(paint-char (+(rect->x (get **current-window** 'screenrect))
					 (times **oldcol** lg-character-x))
			      (+ (rect->y (get **current-window** 'screenrect))
				 (times old-row lg-character-y))
			      char)))
   (setq **oldcol** (1+ **oldcol**))
   )
;;;-----------------------------------------------------------------
;;; update-window adds a d-line and it's extent to the window list
;;;-----------------------------------------------------------------
(defun update-window (win ymin ymax)
   ;;;
   ;;; check if an expression is already in the range given
   ;;;
   (prog ( start end)
      loop
      ;;;
      ;;; if the window has no d-lines in it return the list
      ;;;
      (cond((null win)(return (list(list ymin ymax
					 (concat (stripdollar $outchar)
						 $linenum)
					 $linenum))))
		  ;;;
		  ;;;  check first member in the window to see if it overlaps
		  ;;;  the extent of the new line. if it does, remove it from the
		  ;;;  window list, clear the space ocupied by the old expression
		  ;;;  then loop to check the next exp. -- since we are going
		  ;;;  round robin, if the first expression doesnt overlap
		  ;;;  the new line, we can quit and put the new exp at the end
		  ;;;  of the window list
		  ;;;
		  ((and(>= ymax (caar win))(<= ymin (cadar win)))
		   (setq start (caar win))
		   (setq end   (cadar win))
		   ;
		   ;  clear the area
		   (draw-rectangle
		      (make-rect x (rect->x (get **current-window** 'screenrect))
				 y (+ start
				      (rect->y (get **current-window**
						   'screenrect)))
				 w (rect->w (get **current-window** 'screenrect))
				 h (+ lg-character-y-2 (- end start)))
		      :rule bbzero)

		   (setq win (cdr win))
		   (go loop)))
      ;;;
      ;;; if the d-line is already a member of the window, then
      ;;; we have a continuation line, and we want to add it's
      ;;;  extent to the the previous extent
      ;;;
      (cond((member (concat (stripdollar $outchar)
			    $linenum) (car(reverse win)))
	    (return (reverse( append
			      (list(list (caar (reverse win))
					 ymax
					 (caddar (reverse win))
					 (cadddar (reverse win))))
			      (cdr (reverse win))))))

		    (t(return (append1 win
				       (list ymin
					     ymax
					     (concat (stripdollar $outchar)
						     $linenum)
					     $linenum)))))
      ))

;;;---------------------------------------------------------------
;;; clear out all expressions from the ymin pos to the end of screen
;;; (TTYHEIGHT) clearing the screeen and cleaning out the window list
;;; this is used when an expression wont fit to the end of the screen
;;;-------------------------------------------------------------------
(defun remove-end-window (win ymin)
   ;;;
   ;;; check if an expression is already in the range given
   ;;;
   (prog ( start end)
      (cond((null win)(return nil)))

      loop
      (cond((null win)(return nil))
		  ((and(>= (* lg-character-y ttyheight)
			   (caar win))
			   (<= ymin (cadar win)))
		   (setq start (+(rect->y (get **current-window** 'screenrect))
					 (caar win)))
		   (setq end (+(rect->y (get **current-window** 'screenrect))
				       (cadar win)))

		   (draw-rectangle
		      (make-rect x (rect->x (get **current-window** 'screenrect))
				 y start
				 w  (rect->w (get **current-window** 'screenrect))
				 h  (- end start)) :rule bbzero)
		   (setq win (cdr win))
		   (go loop)))
      (return win)))

(defun d-gequalsign (dummy )
    (cursorpos old-row **oldcol**)
    (tyo* 62.)(tyo* 61.)
    (cursorpos old-row (+ 2 **oldcol**)) 
)
(defun d-notequalsign (dummy )
    (tyo* 33.)(tyo* 61.)
    (cursorpos old-row (+ 2 **oldcol**))  
)
(defun d-leqsign (dummy )
    (tyo* 60.)(tyo* 61.)
    (cursorpos old-row (+ 2 **oldcol**)) 
)

(defun d-notsign (dummy )
    (tyo* 78.)(tyo* 79.)(tyo* 84.)
    (cursorpos old-row (+ 3 **oldcol**))  
)
(defun d-andsign (dummy )
    (tyo* 65.)(tyo* 78.)(tyo* 68.)
    (cursorpos old-row (+ 3 **oldcol**))
)
(defun d-orsign (dummy )
    (tyo* 79.)(tyo* 82.)
    (cursorpos old-row (+ 2 **oldcol**))  
)
(defun d-limit (dummy)
   (setq **str** (list*
		    (list (* **oldcol** lg-character-x)
			  (* (+ 5 **oldcol**) lg-character-x)
			  (* old-row lg-character-y)
			  (* (1+ old-row) lg-character-y)
			  'd-limit)
		    **str**))
   (tyo* #/l )(tyo* #/i)(tyo* #/m)(tyo* #/i)(tyo* #/t))

(defun d-arrow (dummy )
   (setq x1 (1+(* **oldcol** lg-character-x)))
   (setq y1 (+(* old-row lg-character-y) lg-character-y-2))
   (setq x2 (1-(* (1+ **oldcol**) lg-character-x)))
   (setq y2 (+(* old-row lg-character-y) lg-character-y-2))
   (setq x3 (- x2 5))
   (setq y3      (+ (* old-row lg-character-y) 2))
   (setq x4 x3)
   (setq y4       (-(* (1+ old-row) lg-character-y) 2))
   (setq **str** (list*
		    (list x1 x2 y4 y3
			  'd-arrow)
		    **str**))
   (lg-set-point x1 y1)
   (lg-draw-vector x2 y2)
   (lg-draw-vector x3 y3)
   (lg-set-point x2 y2)
   (lg-end-vector x4 y4)
   )
(defun small_char (&optional dummy) nil)
(defun big_char (&optional dummy) nil)
