% INTPATCH.TST
% Test of patch to integrate dependent variables & rational powers

% Author: Francis J. Wright <fjw@maths.qmw.ac.uk>
% Date: 10 April 1992.

% The patch should work independently of ALGINT,
% i.e. with ALGINT either ON or OFF.

on errcont;

% Test of integration of implicitly dependent variables
% =====================================================
% (Based partly on examples by Herbert Melenk and Thomas Wolf.)
% The following all cause hard errors using the standard
% REDUCE 3.4 INT operator, but are correctly handled as symbolic
% expressions after loading the patch.

depend f, x, y;
int(f, x);
df(ws, x);
df(int(f,x), y);
df(int(f,x), z);
df(int(f,x), x, y);

% But these intentionally still cause hard errors:
int(f);  int(f, x, y);
on failhard;  int(exp(x**2), x);  int(f, x);  off failhard;

% NOTE that in the standard system
% int(exp(x**2), x);
% causes 3 identical error messages,
% which this patch fortuitously cures!

% Integration by parts like this works:
for all y,z,x let int(df(y,x)*int(z,x),x) = y*int(z,x) - int(y*z,x);

depend yy,xx;  depend zz,xx;
int(df(yy,xx)*int(zz,xx),xx);

for all y,z,x clear int(df(y,x)*int(z,x),x);


% Test of integration of rational powers
% ======================================
% The following are all returned unevaluated by the standard
% REDUCE 3.4 INT operator (although there are very similar
% integrals that are evaluated correctly).  However, they are
% all evaluated correctly after loading the patch.

int(x**(3/5), x);
int(1/x**(3/5), x);
int(x**(-1/4), x);
int(1/x**(1/4)/x, x);  % specially for TW!

% A non-identifier kernel:
operator f;  int(f(x)**(-5/4), f(x));

% An arbitrary linear combination (SLOW!):
%%%int(a*x**(3/5) + b*x**(-1/4), x);

end;
