#include "def.h"
#include "macro.h"

#ifdef HP500
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>
#endif /* HP500 */

OP cons_zwei;   /* global INTEGER variable 2 */
OP cons_eins;   /* global INTEGER variable 1 */
OP cons_null;   /* global INTEGER variable 0 */
FILE *texout;   /* global variable for texoutput */
OP *speicher;   /* global variable for callocobject/freeall */
INT speicherposition;


INT anfang() 
/* AK 070890 V1.1 */ /* AK 210891 V1.3 */
{
	INT l;
#ifdef HP500
	mallopt(M_MXFAST,0);
	mallopt(M_GRAIN,1);
#endif /* HP500 */
	time(&l);
	srand((unsigned long)l*l);
	memcheck("anfang");
	fflush(stdout); fflush(stderr);
	speicher=(OP *)malloc(SPEICHERSIZE * sizeof(OP));
	if (speicher == NULL)
		error("anfang:no mem");
	speicherposition = -1L;
#ifdef LONGINTTRUE
	start_longint();
#endif /* LONGINTTRUE */
	cons_zwei=callocobject(); m_i_i(2L,cons_zwei);
	cons_eins=callocobject(); m_i_i(1L,cons_eins);
	cons_null=callocobject(); m_i_i(0L,cons_null);
	texout = stdout;
#ifdef NUMBERTRUE	/* 29.10.91: TPMcD */
/*	The third parameter is NULL or the name of a file with cyclotomic data	*/
	setup_numbers(STD_BASIS,TRUE, NULL);
	/*
	setup_numbers(STD_BASIS,TRUE,"CYCLOS.DAT");
	*/
#endif /* NUMBERTRUE */
	return(OK);
}

INT ende() 
/* AK 070890 V1.1 */ /* AK 210891 V1.3 */
{
	INT i;
	INT erg = OK;
#ifdef SCHURTRUE
	schur_ende();
#endif /* SCHURTRUE */
#ifdef PARTTRUE
	part_ende();
#endif /* PARTTRUE */
#ifdef NUMBERTRUE	/* 29.10.91: TPMcD */
	release_numbers();
#endif /* NUMBERTRUE */
	erg += freeall(cons_null);
	erg += freeall(cons_zwei);
	erg += freeall(cons_eins);
	for (i=speicherposition;i>=0L;i--) /* AK 161091 */
		free(speicher[i]); /* AK 161091 */
	free(speicher); /* AK 161091 */
	memcheck("ende");
	fflush(stdout);
	fflush(stderr);
	return erg;
}

INT runtime(l) long *l;
/* AK 270689 V1.0 */ /* AK 070890 V1.1 */ /* AK 210891 V1.3 */
{
#ifdef HP500
	struct tms *buffer = (struct tms *)calloc(1,sizeof(struct tms));
	times(buffer);
	*l = (long) buffer->tms_utime;
	free(buffer);
#endif /* HP500 */
}

INT print_time()
/* AK 160890 V1.1 */ /* AK 210891 V1.3 */
{
long l;
runtime(&l); printf("zeit:%ld\n",l);return OK;
}


INT fusedmemory(fn,stelle) FILE *fn; char *stelle;
/* AK 270689 V1.0 */ /* AK 010290 V1.1 */ /* AK 130691 V1.2 */
/* AK 210891 V1.3 */
{
#ifdef HP500
	struct mallinfo mallinfo();
	struct mallinfo ergebnis;
	free(calloc(1,1));
	ergebnis = mallinfo(0);
	fprintf(fn,"%s: ",stelle);
	fprintf(fn,"%d ",ergebnis.uordblks);
	fprintf(fn,"%d\n",ergebnis.usmblks);
	return(OK);
#else /* HP500 */
#ifdef TURBOC
	fprintf(fn,"%s: ",stelle);
	fprintf(fn,"%ul\n",coreleft());
	return(OK);
#else /* TURBOC */
	return(OK);
#endif /* TURBOC */
#endif /* HP500 */

}

INT mem_small()
/* anzahl small memory zurueck */
/* AK 270689 V1.0 */ /* AK 070890 V1.1 */ /* AK 210891 V1.3 */
{
#ifdef HP500
	struct mallinfo mallinfo();
	struct mallinfo ergebnis;
	ergebnis = mallinfo(0);
	return(ergebnis.usmblks);
#else /* HP500 */
	return(0);
#endif /* HP500 */
}


INT memcheck(stelle) char *stelle;
/* informationen ueber memory 31/10/86 */
/* AK 270689 V1.0 */ /* AK 010290 V1.1 */ /* AK 210891 V1.3 */
{
#ifdef HP500
	struct mallinfo mallinfo();
	struct mallinfo ergebnis;
	free(calloc(1,1));
	ergebnis = mallinfo(0);
	printf("memory information  %s\n",stelle);
	printf("total space     %d\n",ergebnis.arena);
	printf("block number    %d\n",ergebnis.ordblks);
	printf("small blocks    %d\n",ergebnis.smblks);
	printf("used blocks     %d\n",ergebnis.uordblks);
	printf("free blocks     %d\n",ergebnis.fordblks);
	printf("used sm. blocks %d\n",ergebnis.usmblks);
	printf("free sm. blocks %d\n",ergebnis.fsmblks);
	return(OK);
#else /* HP500 */
	return(OK);
#endif /* HP500 */
}

INT error(fehlertext) char *fehlertext;
/* if answer == a ==> abort
   if answer == g ==> go on
   if answer == f ==> go on forever
   else               exit */
/* AK 270689 V1.0 */ /* AK 070890 V1.1 */
/* AK 070291 V1.2 explanation of possible input */
/* AK 210891 V1.3 */
{
	char antwort[2];
	static int forever=0;
	if (forever==2) return ERROR;
	fflush(stdout);
	fflush(stderr);
	fprintf(stderr,
		"\nenter a to abort with core dump, g to go, else stop\n");
	fprintf(stderr,"ERROR: %s?: ",fehlertext);
	fflush(stderr);
	if (forever==1) return ERROR;
	scanf("%s",antwort);
	if (antwort[0] == 'a') abort();
	if (antwort[0] == 'f') {forever = 1; return ERROR;}
	if (antwort[0] == 's') {forever = 2; return ERROR;}
	if (antwort[0] == 'g') return ERROR;
	exit();
}


INT no_memory()
/* AK 090792 */
{
	return error("no memory left");
}

INT debugprint(a) OP a;
/* AK 260788 */ /* AK 030789 V1.0 */ /* AK 130690 V1.1 */ /* AK 210891 V1.3 */
{
	OBJECTKIND kind;
	if (a==NULL) { 
		fprintf(stderr,"NULL\n"); 
		return(OK); 
	}
	kind = s_o_k(a);
	switch ((int)kind)
	/* abschluss immer mit newline */
	{
	case 0: 
		fprintf(stderr,"kind:0=empty\n");
		break;
	case 1: 
		{
			fprintf(stderr,"kind:1=integer value:");
			fprintf(stderr,"%ld",s_i_i(a));
			return(OK);
		}
#ifdef VECTORTRUE
        case 26:
	case 2: 
		{
			INT i;
		if (kind == 2)
			fprintf(stderr,"kind:2=vector length:");
		if (kind == 26)
			fprintf(stderr,"kind:26=comp length:");

			debugprint(s_v_l(a));
			for (i=0;i<s_v_li(a);i++)
			{
				fprintf(stderr,"%d-komponente:",i);
				debugprint(s_v_i(a,i));
			}
			return(OK);
		}
#endif /* VECTORTRUE */
#ifdef PARTTRUE
	case 12: 
		{
		fprintf(stderr,"kind:12=augpartition kind:%d",s_pa_k(a));
		fprintf(stderr,"self:");
		debugprint(s_pa_s(a));
		return(OK);
		}
#endif /* PARTTRUE */
#ifdef PARTTRUE
	case 3: 
		{
			fprintf(stderr,"kind:3=partition kind:%d",s_pa_k(a));
			fprintf(stderr,"self:");
			debugprint(s_pa_s(a));
			return(OK);
		}
#endif /* PARTTRUE */
#ifdef BRUCHTRUE
	case 4: 
		{
			fprintf(stderr,"kind:4=bruch oben:");
			debugprint(s_b_o(a));
			fprintf(stderr,"unten:");
			debugprint(s_b_u(a));
			return(OK);
		}
#endif /* BRUCHTRUE */
#ifdef PERMTRUE
	case 6: 
		{
			fprintf(stderr,"kind:6=permutation kind:%d",s_p_k(a));
			fprintf(stderr,"self:");
			debugprint(s_p_s(a));
			return(OK);
		}
#endif
#ifdef SKEWPARTTRUE
	case 7: 
		{
			fprintf(stderr,"kind:7=skewpartition gross:");
			debugprint(s_spa_g(a));
			fprintf(stderr,"klein:");
			debugprint(s_spa_k(a));
			return(OK);
		}
#endif
#ifdef TABLEAUXTRUE
	case 8: 
		{
			fprintf(stderr,"kind:8=tableaux self:");
			debugprint(s_t_s(a));
			fprintf(stderr,"umriss:");
			debugprint(s_t_u(a));
			return(OK);
		}
#endif /* TABLEAUXTRUE */
#ifdef POLYTRUE
	case 9: 
		{
			fprintf(stderr,"kind:9=polynom self:");
			debugprint(s_l_s(a));
			fprintf(stderr,"next:");
			debugprint(s_l_n(a));
			return(OK);
		}
#endif /* POLYTRUE */
#ifdef SCHURTRUE
	case 13:
	case 10:
		{
		if (kind == 10)
			fprintf(stderr,"kind:10=schur self:");
		if (kind == 13)
			fprintf(stderr,"kind:13=homsym self:");
			debugprint(s_l_s(a));
			fprintf(stderr,"next:");
			debugprint(s_l_n(a));
			return(OK);
		}
#endif /* SCHURTRUE */
#ifdef MATRIXTRUE
	case 11:
		{
			INT i,j;
			fprintf(stderr,"kind:11=matrix height:");
			debugprint(s_m_h(a));
			fprintf(stderr,"length:");
			debugprint(s_m_l(a));
			fprintf(stderr,"self:");
			for (i=0;i<s_m_hi(a);i++)
				for (j=0;j<s_m_li(a);j++)
				{
					fprintf(stderr,"%d %d-komponente:",i,j);
					debugprint(s_m_ij(a,i,j));
				}
			return(OK);
		}
#endif /* MATRIXTRUE */
#ifdef MATRIXTRUE
	case 27:
		{
			INT i,j;
			fprintf(stderr,"kind:27=kranztypus height:");
			debugprint(s_m_h(a));
			fprintf(stderr,"length:");
			debugprint(s_m_l(a));
			fprintf(stderr,"self:");
			for (i=0;i<s_m_hi(a);i++)
				for (j=0;j<s_m_li(a);j++)
				{
					fprintf(stderr,"%d %d-komponente:",i,j);
					debugprint(s_m_ij(a,i,j));
				}
			return(OK);
		}
#endif /* MATRIXTRUE */
#ifdef SCHUBERTTRUE
	case 14:
		{
			fprintf(stderr,"kind:14=schubert self:");
			debugprint(s_l_s(a));
			fprintf(stderr,"next:");
			debugprint(s_l_n(a));
			return(OK);
		}
#endif /* SCHUBERTTRUE */
#ifdef LISTTRUE
	case 20:
		{
			fprintf(stderr,"kind:20=list self:");
			debugprint(s_l_s(a));
			fprintf(stderr,"next:");
			debugprint(s_l_n(a));
			return(OK);
		}
#endif /* LISTTRUE */
#ifdef MONOMTRUE
	case 21:
		{
			fprintf(stderr,"kind:21=monom koeff:");
			debugprint(s_mo_k(a));
			fprintf(stderr,"self:");
			debugprint(s_mo_s(a));
			return(OK);
		}
#endif /* MONOMTRUE */
#ifdef LONGINTTRUE
	case 22: return(debugprint_longint(a));
#endif /* LONGINTTRUE */
#ifdef NUMBERTRUE
	case 124: {
			fprintf(stderr,"kind:124=cyclotomic self:");
			debugprint(s_n_s(a));
			return(OK);
		}
#endif /*NUMBERTRUE*/
#ifdef MONOPOLYTRUE
	case 126:
		{
			fprintf(stderr,"kind:126=monopoly self:");
			debugprint(s_l_s(a));
			fprintf(stderr,"next:");
			debugprint(s_l_n(a));
			return(OK);
		}
#endif /* MONOPOLYTRUE */
	default: 
		fprintf(stderr,"kind:%d unknown\n",s_o_k(a));
		break;
	}
	return OK;
}
