/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*            Analyseur syntactique pour la calculette             */
/*                                                                 */
/*                       copyright Babe Cool                       */
/*                                                                 */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

#include "genpari.h"

GEN seq(), expr(), exprcomp(), expradd(), terme(), facteur();
GEN truc(), identifier(), constante();
void skipseq(), skipexpr(), skipexprcomp(), skipexpradd(), skipterme();
void skipfacteur(), skiptruc(), skipconstante(), skipidentifier();
entree *findentry(), *skipentry();

static char *analyseurs,*labellist[100];
static long analyseurtetpil;

GEN lisexpr(t)
     char *t;
     
{
  GEN res;
  long av, oldtetpil = analyseurtetpil;
  char *olds = analyseurs;
  analyseurs = t; analyseurtetpil = av = avma;
  res = expr();
  res = gerepile(av, analyseurtetpil, res);      
  analyseurtetpil = oldtetpil; analyseurs = olds;
  return res;
}

GEN readexpr(c)
     char **c;
{
  char *olds = analyseurs, *oldc = *c;
  analyseurs = oldc; skipexpr();
  if ((*analyseurs) && !separe(*analyseurs)) err(caracer1, analyseurs);
  *c = analyseurs; analyseurs = olds;
  return lisexpr(oldc);
}

GEN lisseq(t)
     char *t;
{
  GEN res;
  long av, oldtetpil = analyseurtetpil;
  char *olds = analyseurs;
  analyseurs = t; analyseurtetpil = av = avma;
  res = seq();
  res = gerepile(av, analyseurtetpil, res);      
  analyseurtetpil = oldtetpil; analyseurs = olds;
  return res;
}

GEN readseq(c)
     char **c;
{
  long i;
  char *olds = analyseurs, *oldc = *c;
  for(i=0;i<100;i++) labellist[i]=(char*)0;
  analyseurs = oldc; skipseq();
  *c = analyseurs; analyseurs = olds;
  return lisseq(oldc);
}

entree fonctions[]={
  {"O",50,0,0},
  {"abs",1,(void *)gabs,0},
  {"acos",1,(void *)gacos,0},
  {"acosh",1,(void *)gach,0},
  {"addell",3,(void *)addell,0},
  {"adj",1,(void *)adj,0},
  {"agm",2,(void *)agm,0},
  {"akell",2,(void *)akell,0},
  {"algdep",23,(void *)algdep,0},
  {"algdep2",33,(void *)algdep2,0},
  {"anell",23,(void *)anell,0},
  {"apell",2,(void *)apell,0},
  {"apell2",2,(void *)apell2,0},
  {"apprpadic",2,(void *)apprgen9,0},
  {"arg",1,(void *)garg,0},
  {"asin",1,(void *)gasin,0},
  {"asinh",1,(void *)gash,0},
  {"assmat",1,(void *)assmat,0},
  {"atan",1,(void *)gatan,0},
  {"atanh",1,(void *)gath,0},
  {"base",13,(void *)base,0},
  {"bernreal",11,(void *)bernreal,0},
  {"bernvec",11,(void *)bernvec,0},
  {"bezout",2,(void *)vecbezout,0},
  {"bigomega",1,(void *)gbigomega,0},
  {"bin",21,(void *)binome,0},
  {"binary",1,(void *)binaire,0},
  {"bittest",2,(void *)gbittest,0},
  {"boundcf",21,(void *)gboundcf,0},
  {"boundfact",21,(void *)boundfact,0},
  {"box",59,(void *)rectbox,0},
  {"buchimag",3,(void *)buchimag,0},
  {"buchreal",4,(void *)buchreal,0},
  {"ceil",1,(void *)gceil,0},
  {"centerlift",1,(void *)centerlift,0},
  {"cf",1,(void *)gcf,0},
  {"cf2",2,(void *)gcf2,0},
  {"changevar",2,(void *)changevar,0},
  {"char",14,(void *)caradj0,0},
  {"char1",14,(void *)caract,0},
  {"char2",14,(void *)carhess,0},
  {"chell",2,(void *)coordch,0},
  {"chinese",2,(void *)chinois,0},
  {"chptell",2,(void *)pointch,0},
  {"classno",1,(void *)classno,0},
  {"classno2",1,(void *)classno2,0},
  {"coeff",21,(void *)truecoeff,0},
  {"compo",21,(void *)compo,0},
  {"compose",2,(void *)compose,0},
  {"comprealraw",2,(void *)comprealraw,0},
  {"concat",2,(void *)concat,0},
  {"conj",1,(void *)gconj,0},
  {"content",1,(void *)content,0},
  {"convol",2,(void *)convol,0},
  {"cos",1,(void *)gcos,0},
  {"cosh",1,(void *)gch,0},
  {"cursor",11,(void*)rectcursor,0},
  {"cvtoi",13,(void *)gcvtoi,0},
  {"cyclo",11,(void *)cyclo,0},
  {"denom",1,(void *)denom,0},
  {"deriv",14,(void *)deriv,0},
  {"det",1,(void *)det,0},
  {"det2",1,(void *)det2,0},
  {"detr",1,(void *)detreel,0},
  {"dilog",1,(void *)dilog,0},
  {"disc",1,(void *)discsr,0},
  {"discf",1,(void *)discf,0},
  {"divisors",1,(void *)divisors,0},
  {"divres",2,(void *)gdiventres,0},
  {"divsum",22,(void *)divsomme,0},
  {"draw",1,(void*)rectdraw,0},
  {"eigen",1,(void *)eigen,0},
  {"eint1",1,(void *)eint1,0},
  {"erfc",1,(void *)gerfc,0},
  {"eta",1,(void *)eta,0},
  {"euler",0,(void *)mpeuler,0},
  {"eval",1,(void *)geval,0},
  {"exp",1,(void *)gexp,0},
  {"extract",2,(void *)extract,0},
  {"fact",11,(void *)mpfactr,0},
  {"factfq",3,(void *)factmod9,0},
  {"factmod",2,(void *)factmod,0},
  {"factor",1,(void *)factor,0},
  {"factoredbase",28,(void *)factoredbase,0},
  {"factoreddiscf",2,(void *)factoreddiscf,0},
  {"factoredpolred",2,(void *)factoredpolred,0},
  {"factoredpolred2",2,(void *)factoredpolred2,0},
  {"factornf",2,(void *)polfnf,0},
  {"factorpadic",32,(void *)factorpadic,0},
  {"factpol",21,(void *)factpol,0},
  {"factpol2",21,(void *)factpol2,0},
  {"fibo",11,(void *)fibo,0},
  {"floor",1,(void *)gfloor,0},
  {"for",83,(void *)forpari,0},
  {"fordiv",84,(void *)fordiv,0},
  {"forprime",83,(void *)forprime,0},
  {"forstep",86,(void *)forstep,0},
  {"frac",1,(void *)gfrac,0},
  {"galois",1,(void *)galois,0},
  {"galoisconj",1,(void *)galoisconj,0},
  {"gamh",1,(void *)ggamd,0},
  {"gamma",1,(void *)ggamma,0},
  {"gauss",2,(void *)gauss,0},
  {"gcd",2,(void *)ggcd,0},
  {"globalred",1,(void *)globalreduction,0},
  {"goto",61,0,0},
  {"hclassno",1,(void *)classno3,0},
  {"hell",2,(void *)ghell,0},
  {"hell2",2,(void *)ghell2,0},
  {"hell3",2,(void *)ghell3,0},
  {"hermite",1,(void *)hnf,0},
  {"hess",1,(void *)hess,0},
  {"hilb",30,(void *) hil,0},
  {"hilbert",11,(void *)hilb,0},
  {"hilbp",20,(void *) hil,0},
  {"hvector",22,(void *)vecteur,0},
  {"hyperu",3,(void *)hyperu,0},
  {"i",0,(void *)geni,0},
  {"idmat",11,(void *)idmat,0},
  {"if",80,0,0},
  {"imag",1,(void *)gimag,0},
  {"image",1,(void *)image,0},
  {"image2",1,(void *)image2,0},
  {"incgam",2,(void *)incgam,0},
  {"incgam1",2,(void *)incgam1,0},
  {"incgam2",2,(void *)incgam2,0},
  {"incgam3",2,(void *)incgam3,0},
  {"incgam4",3,(void *)incgam4,0},
  {"indexrank",1,(void *)indexrank,0},
  {"indsort",1,(void *)indexsort,0},
  {"initalg",1,(void *)initalg,0},
  {"initell",1,(void *)initell,0},
  {"initell2",1,(void *)initell2,0},
  {"initrect",34,(void*)initrect,0},
  {"integ",14,(void *)integ,0},
  {"intersect",2,(void *)intersect,0},
  {"intgen",37,(void *)rombint,0},
  {"intinf",37,(void *)qromi,0},
  {"intnum",37,(void *)qromb,0},
  {"intopen",37,(void *)qromo,0},
  {"inverseimage",2,(void *)inverseimage,0},
  {"isfund",1,(void *)gisfundamental,0},
  {"isincl",2,(void *)nfincl,0},
  {"isisom",2,(void *)nfiso,0},
  {"isoncurve",20,(void *)oncurve,0},
  {"isprime",1,(void *)gisprime,0},
  {"ispsp",1,(void *)gispsp,0},
  {"isqrt",1,(void *)racine,0},
  {"issqfree",1,(void *)gissquarefree,0},
  {"issquare",1,(void *)gcarreparfait,0},
  {"jacobi",1,(void *)jacobi,0},
  {"jbesselh",2,(void *)jbesselh,0},
  {"jell",1,(void *)jell,0},
  {"karamul",32,(void *)karamul,0},
  {"kbessel",2,(void *)kbessel,0},
  {"kbessel2",2,(void *)kbessel2,0},
  {"ker",1,(void *)ker,0},
  {"keri",1,(void *)keri,0},
  {"kerint",1,(void *)kerint,0},
  {"kerint1",1,(void *)kerint1,0},
  {"kerint2",1,(void *)kerint2,0},
  {"kerr",1,(void *)kerreel,0},
  {"kill",85,0,0},
  {"killrect",11,(void *)killrect,0},
  {"kro",2,(void *)gkronecker,0},
  {"label",60,0,0},
  {"laplace",1,(void *)laplace,0},
  {"lcm",2,(void *)glcm,0},
  {"legendre",11,(void *)legendre,0},
  {"length",1,(void *)glength,0},
  {"lex",20,(void *)lexcmp,0},
  {"lexsort",1,(void *)lexsort,0},
  {"lift",1,(void *)lift,0},
  {"lindep",1,(void *)lindep,0},
  {"lindep2",23,(void *)lindep2,0},
  {"line",59,(void *)rectline,0},
  {"lines",35,(void *)rectlines,0},
  {"lll",1,(void *)lll,0},
  {"lll1",1,(void *)lll1,0},
  {"lllgen",1,(void *)lllgen,0},
  {"lllgram",1,(void *)lllgram,0},
  {"lllgram1",1,(void *)lllgram1,0},
  {"lllgramgen",1,(void *)lllgramgen,0},
  {"lllgramint",1,(void *)lllgramint,0},
  {"lllgramkerim",1,(void *)lllgramkerim,0},
  {"lllgramkerimgen",1,(void *)lllgramkerimgen,0},
  {"lllint",1,(void *)lllint,0},
  {"lllkerim",1,(void *)lllkerim,0},
  {"lllkerimgen",1,(void *)lllkerimgen,0},
  {"lllrat",1,(void *)lllrat,0},
  {"ln",1,(void *)glog,0},
  {"lngamma",1,(void *)glngamma,0},
  {"localred",2,(void *)localreduction,0},
  {"log",1,(void *)glog,0},
  {"logagm",1,(void *)glogagm,0},
  {"lseriesell",4,(void *)lseriesell,0},
  {"mat",1,(void *)gtomat,0},
  {"matell",2,(void *)matell,0},
  {"matextract",3,(void *)matextract,0},
  {"matinvr",1,(void *)invmatreel,0},
  {"matsize",1,(void *)matsize,0},
  {"matrix",49,(void *)matrice,0},
  {"matrixqz",2,(void *)matrixqz,0},
  {"matrixqz2",1,(void *)matrixqz2,0},
  {"matrixqz3",1,(void *)matrixqz3,0},
  {"max",2,(void *)gmax,0},
  {"min",2,(void *)gmin,0},
  {"minim",33,(void *)minim,0},
  {"mod",25,(void *)gmodulcp,0},
  {"modp",25,(void *)gmodulo,0},
  {"modreverse",1,(void *)polymodrecip,0},
  {"move",34,(void*)rectmove,0},
  {"mu",1,(void *)gmu,0},
  {"newtonpoly",2,(void *)newtonpoly,0},
  {"nextprime",1,(void *)bigprem,0},
  {"norm",1,(void *)gnorm,0},
  {"norml2",1,(void *)gnorml2,0},
  {"nucomp",3,(void *)nucomp,0},
  {"numdiv",1,(void *)numbdiv,0},
  {"numer",1,(void *)numer,0},
  {"nupow",2,(void *)nupow,0},
  {"o",50,0,0},
  {"omega",1,(void *)gomega,0},
  {"ordell",2,(void *)ordell,0},
  {"order",1,(void *)order,0},
  {"ordred",1,(void *)ordred,0},
  {"pascal",11,(void *)pasc,0},
  {"permutation",24,(void *)permute,0},
  {"pf",2,(void *)primeform,0},
  {"phi",1,(void *)phi,0},
  {"pi",0,(void *)mppi,0},
  {"plot",37,(void *)plot,0},
  {"ploth",37,(void *)ploth,0},
  {"ploth2",37,(void *)ploth2,0},
  {"plothraw",2,(void *)plothraw,0},
  {"pnqn",1,(void *)pnqn,0},
  {"point",34,(void *)rectpoint,0},
  {"pointell",2,(void *)pointell,0},
  {"points",35,(void *)rectpoints,0},
  {"polint",31,(void *)polint,0},
  {"polred",1,(void *)polred,0},
  {"polred2",1,(void *)polred2,0},
  {"polsym",21,(void *)polsym,0},
  {"poly",14,(void *)gtopoly,0},
  {"polylog",24,(void *)gpolylog,0},
  {"polylogd",24,(void *)polylogd,0},
  {"polylogdold",24,(void *)polylogdold,0},
  {"polylogp",24,(void *)polylogp,0},
  {"polyrev",14,(void *)gtopolyrev,0},
  {"postdraw",1,(void *)postdraw,0},
  {"postploth",37,(void *)postploth,0},
  {"postploth2",37,(void *)postploth2,0},
  {"postplothraw",2,(void *)postplothraw,0},
  {"powell",3,(void *)powell,0},
  {"powrealraw",23,(void *)powrealraw,0},
  {"pprint",54,0,0},
  {"pprint1",52,0,0},
  {"prec",21,(void *)gprec,0},
  {"prime",11,(void *)prime,0},
  {"primes",11,(void *)primes,0},
  {"primroot",1,(void *)gener,0},
  {"print",53,0,0},
  {"print1",51,0,0},
  {"prod",48,(void *)produit,0},
  {"prodeuler",37,(void *)prodeuler,0},
  {"prodinf",27,(void *)prodinf,0},
  {"prodinf1",27,(void *)prodinf1,0},
  {"psi",1,(void *)gpsi,0},
  {"qfi",3,(void *)qfi,0},
  {"qfr",4,(void *)qfr,0},
  {"quadgen",1,(void *)quadgen,0},   
  {"quadpoly",1,(void *)quadpoly,0},   
  {"random",0,(void *)genrand,0},
  {"rank",10,(void *)rank,0},
  {"rbox",34,(void *)rectrbox,0},      
  {"read",56,0,0},
  {"real",1,(void *)greal,0},
  {"recip",1,(void *)polrecip,0},      
  {"redcomp",1,(void *)redcomp,0},      
  {"redreal",1,(void *)redreal,0},      
  {"redrealnod",2,(void *)redrealnod,0},      
  {"regula",1,(void *)regula,0}, 
  {"reorder",1,(void *)reorder,0}, 
  {"resultant",2,(void *)subres,0},    
  {"resultant2",2,(void *)resultant2,0},    
  {"reverse",1,(void *)recip,0}, 
  {"rhoreal",1,(void *)rhoreal,0},      
  {"rhorealnod",2,(void *)rhorealnod,0},      
  {"rline",34,(void *)rectrline,0},      
  {"rmove",34,(void *)rectrmove,0},      
  {"rndtoi",13,(void *)grndtoi,0},
  {"rootmod",2,(void *)rootmod,0},
  {"rootmod2",2,(void *)rootmod2,0},
  {"rootpadic",32,(void *)rootpadic,0},
  {"roots",1,(void *)roots,0},
  {"rootslong",1,(void *)rootslong,0},
  {"rootsof1",10,(void *)rootsof1,0},
  {"round",1,(void *)ground,0},
  {"rounderror",10,(void *)rounderror,0},
  {"rpoint",34,(void *)rectrpoint,0},      
  {"series",14,(void *)gtoser,0},
  {"setprecision",15,(void *)setprecr,0},
  {"setserieslength",15,(void *)setserieslength,0},
  {"shift",21,(void *)gshift,0},
  {"shiftmul",21,(void *)gmul2n,0},
  {"sigma",1,(void *)sumdiv,0},
  {"sigmak",24,(void *)sumdivk,0},
  {"sign",10,(void *)gsigne,0},
  {"signat",1,(void *)signat,0},
  {"simplify",1,(void *)simplify,0},
  {"sin",1,(void *)gsin,0},
  {"sinh",1,(void *)gsh,0},
  {"size",10,(void *)gsize,0},
  {"smallbase",13,(void *)smallbase,0},
  {"smalldiscf",1,(void *)smalldiscf,0},
  {"smallfact",1,(void *)smallfact,0},
  {"smallinitell",1,(void *)smallinitell,0},
  {"smallpolred",1,(void *)smallpolred,0},
  {"smallpolred2",1,(void *)smallpolred2,0},
  {"smith",1,(void *)smith,0},
  {"smith2",1,(void *)smith2,0},
  {"solve",37,(void *)zbrent,0},
  {"sort",1,(void *)sort,0},
  {"sqr",1,(void *)gsqr,0},
  {"sqred",1,(void *)sqred,0},
  {"sqrt",1,(void *)gsqrt,0},
  {"srgcd",2,(void *)srgcd,0},
  {"string",57,(void*)rectstring,0},
  {"sturm",10,(void *)sturm,0},
  {"sturmpart",30,(void *)sturmpart,0},
  {"subell",3,(void *)subell,0},
  {"subst",26,(void *)gsubst,0},
  {"sum",48,(void *)somme,0},
  {"sumalt",27,(void *)sumalt,0},
  {"suminf",27,(void *)suminf,0},
  {"sumpos",27,(void *)sumpos,0},
  {"supplement",1,(void *)suppl,0},
  {"tan",1,(void *)gtan,0},
  {"tanh",1,(void *)gth,0},
  {"taylor",12,(void *)tayl,0},
  {"tchebi",11,(void *)tchebi,0},
  {"tchirnhausen",1,(void *)tchirnhausen,0},
  {"teich",1,(void *)teich,0},
  {"texprint",55,0,0},
  {"theta",2,(void *)theta,0},
  {"thetanullk",21,(void *)thetanullk,0},
  {"trace",1,(void *)trace,0},
  {"trans",1,(void *)gtrans,0},
  {"trunc",1,(void *)gtrunc,0},
  {"type",1,(void *)gtype,0},
  {"unit",1,(void *)fundunit,0},
  {"until",82,0,0},
  {"valuation",20,(void *)ggval,0},
  {"vec",1,(void *)gtovec,0},
  {"vecsort",21,(void *)vecsort,0},
  {"vector",22,(void *)vecteur,0},
  {"vvector",22,(void *)vvecteur,0},
  {"wf",1,(void *)wf,0},
  {"wf2",1,(void *)wf2,0},
  {"while",81,0,0},
  {"zell",2,(void *)zell,0},
  {"zeta",1,(void *)gzeta,0},
  {"zzzz",1,(void *)kerint2,0}
};

long    NUMFUNC=sizeof(fonctions)/sizeof(entree);

static void matcherr(c)
     char c;
{
  static char reste[100];
  char *p;
  long i;
  
  for(analyseurs--, p=reste, *p++=c, i=0; i<97; i++) *p++ = *analyseurs++;
  *p = 0;err(matcher1,reste);
}

#define match(c)  if(*analyseurs++ != c) matcherr(c)

GEN seq()
     
{
  GEN res=gnil;
  for(;;)
    {
      while(separe(*analyseurs)) analyseurs++;
      if ((!*analyseurs) || (*analyseurs == ')') || (*analyseurs == ',')) return res;
      res = expr();
      if(!separe(*analyseurs)) return res;
    }
}

GEN expr()
{
  GEN (*func[4]) (),aux,e,e1,e2,e3;
  long niveau;
  
  for(niveau=0;niveau<4;niveau++) func[niveau]=NULL;
  e1=e2=e3=(GEN)0;
  niveau=3;
  for(;;)
    switch(niveau)
      {
      case 3: aux=facteur();
        if(func[3]) {analyseurtetpil=avma;e3=func[3](e3,aux);}
        else e3=aux;
        switch(*analyseurs)
	  {
          case '*': analyseurs++;func[3]=gmul;break;
          case '/': analyseurs++;func[3]=gdiv;break;
          case '\\': analyseurs++;func[3]=gdivent;break;
          case '%': analyseurs++;func[3]=gmod;break;
          default: niveau--;func[3]=NULL;
	  }
        break;
      case 2: 
        if(!e3) {niveau++;break;}
        if(func[2]) {analyseurtetpil=avma;e2=func[2](e2,e3);}
        else e2=e3;
        e3=(GEN)0;
        switch(*analyseurs)
	  {
          case '+': analyseurs++;func[2]=gadd;niveau++;break;
          case '-': analyseurs++;func[2]=gsub;niveau++;break;
          default: niveau--;func[2]=NULL;
	  }
        break;
      case 1: 
        if(!e2) {niveau++;break;}
        if(func[1]) {analyseurtetpil=avma;e1=func[1](e1,e2);}
        else e1=e2;
        e2=(GEN)0;
        switch(*analyseurs)
	  {
          case '<': analyseurs++;
            switch(*analyseurs)
	      {
              case '=': analyseurs++;func[1]=gle;break;
              case '>': analyseurs++;func[1]=gne;break;
		default : func[1]=glt;
	      }
            niveau++;break;
          case '>': analyseurs++;
            if((*analyseurs)=='=') {analyseurs++;func[1]=gge;}
            else func[1]=ggt;
            niveau++;break;
          case '=': 
            if((analyseurs[1])=='=') {analyseurs+=2;func[1]=geq;niveau++;}
            break;
          case '!': 
            if((analyseurs[1])=='=') {analyseurs+=2;func[1]=gne;niveau++;}
            break;
          default: niveau--;func[1]=NULL;
	  }
        break;
      case 0: 
        if(!e1) {niveau++;break;}
        if(func[0]) {analyseurtetpil=avma;e=func[0](e,e1);}
        else e=e1;
        e1=(GEN)0;
        switch(*analyseurs)
	  {
          case '&': analyseurs++;if(*analyseurs=='&') analyseurs++;func[0]=gand;niveau++;break;
          case '|': analyseurs++;if(*analyseurs=='|') analyseurs++;func[0]=gor;niveau++;break;
          default: return e;
	  }
      }
}

GEN facteur()
{
  GEN tru,p1,arg,arg1;
  long tx,c,e,av2,flcol,flrow;
  long plus = (*analyseurs =='+')||(*analyseurs =='-')?(*analyseurs++=='+'):1;
  tru=truc();
  for (;;) switch(*analyseurs)
    {
    case '^': analyseurs++;p1=facteur();analyseurtetpil=avma; tru=gpui(tru,p1,prec);break;
    case '~': analyseurs++;analyseurtetpil=avma;tru=gtrans(tru);break;
    case '_': analyseurs++;analyseurtetpil=avma;tru=gconj(tru);break;
    case '\'': analyseurs++;analyseurtetpil=avma;tru=deriv(tru,gvar9(tru));break;
    case '[': 
      tx=typ(p1=tru);
      if((tx<17)||(tx>19)) err(caracer1,analyseurs);
      analyseurs++;av2=avma;flcol=flrow=0;
      if(tx<19)
	{
	  arg=expr();if(typ(arg)!=1) err(caseer);
	  c=itos(arg);if((c<1)||(c>=lg(p1))) err(arrayer1);
	}
      else
	{
	  if(lg(p1)==1) err(arrayer1);
	  if(*analyseurs==',')
	    {
	      analyseurs++;arg=expr();if(typ(arg)!=1) err(caseer);
	      c=itos(arg);if((c<1)||(c>=lg(p1))) err(arrayer1);
	      flcol=1;
	    }
	  else
	    {
	      arg=expr();if(typ(arg)!=1) err(caseer);
	      e=itos(arg);if((e<1)||(e>=lg(p1[1]))) err(arrayer1);
	      match(',');
	      if(*analyseurs==']') flrow=1;
	      else
		{
		  arg1=expr();if(typ(arg1)!=1) err(caseer);
		  c=itos(arg1);
		  if((c<1)||(c>=lg(p1))) err(arrayer1);
		}
	    }
	}
      match(']'); analyseurtetpil=avma=av2;
      if((tx<19)||flcol) tru=gcopy(p1[c]);
      else
	{
	  if(flrow)
	    {
	      tru=cgetg(lg(p1),17);
	      for(c=1;c<lg(p1);c++) tru[c]=lcopy(((GEN)p1[c])[e]);
	    }
	  else tru = gcopy(((GEN)p1[c])[e]);
	}
      break;
    case '!': analyseurs++;if((*analyseurs)!='=') {analyseurtetpil=avma;tru=mpfact(itos(tru));break;} else analyseurs--;
    default: if(plus) return tru; else {analyseurtetpil=avma;return gneg(tru);}
    }
}

GEN truc()
{
  long i,n=0,j,p=0,m=1;
  GEN *table,p1;
  
  if (isalpha(*analyseurs)) return identifier();
  if (isdigit(*analyseurs) || (*analyseurs=='.')) return constante();
  switch(*analyseurs++)
    {
    case '(': p1=expr();match(')');return p1;
    case '[':
      table = (GEN *)newbloc(paribuffsize>>1);
      if (*analyseurs!=']') 
	{do table[++n]=expr();while (*analyseurs++==',');analyseurs--;}
      switch (*analyseurs++)
	{
        case ']': analyseurtetpil=avma;p1=cgetg(n+1,17);
          for (i=1;i<=n;i++) p1[i]=lcopy(table[i]);
          break;
        case ';': m=n;do table[++n]=expr();while (*analyseurs++!=']');
          if (n % m) err(recter1);
          p=n/m;analyseurtetpil=avma;p1=cgetg(m+1,19);
          for (i=1;i<=m;i++) p1[i]=(long)cgetg(p+1,18);
          for (j=1;j<=m;j++)
            for(i=1;i<=p;i++)
              ((GEN)p1[j])[i]=lcopy(table[(i-1)*m+j]);
          break;
        default: err(vectmater1);
	}
      killbloc((GEN)table);
      return p1;
    case '%':
      p=0;while((*analyseurs)=='`') {analyseurs++;p++;}
      if(p>tglobal) err(referer1);
      if(p) return g[tglobal-p];
      while (isdigit(*analyseurs)) p = 10*p + *analyseurs++ - '0';
      if(p>tglobal) err(referer2);
      return g[p];
    }
  err(caracer1,analyseurs-1);
}

int numvar(x)
     GEN x;
{
  if(typ(x)!=10) err(numvarer);
  if(lgef(x)!=4) err(numvarer);
  if((!gcmp0(x[2])) || (!gcmp1(x[3]))) err(numvarer);
  return varn(x);
}


GEN identifier()
{
  long c,e,va,m,nparam,i,av,av2,tx,flrow,flcol;
  static long yatileugoto;
  GEN arg,arg1,arg2,arg3,arg4,res=gnil,(*f)(),p1;
  char *ch1, *ch2, *readbuffer;
  entree *ep, *ep1, **p;
  
  ep = findentry();
  if (ep->valence < 100) /* fonctions predefinies */
    {
      f = (GEN (*)())ep->value;
      if (!ep->valence && (*analyseurs != '(')) return (*f)(prec);
      match('(');
      switch(ep->valence)
	{
	case 0: res=(*f)(prec);break;
	case 1: arg=expr();analyseurtetpil=avma;
	  res=(*f)(arg,prec);break;
	case 2: arg=expr();match(',');arg1=expr();
	  analyseurtetpil=avma;res=(*f)(arg,arg1,prec);break;
	case 3: arg=expr();match(',');arg1=expr();
	  match(',');arg2=expr();analyseurtetpil=avma;
	  res=(*f)(arg,arg1,arg2,prec);break;
	case 4: arg=expr();match(',');arg1=expr();
	  match(',');arg2=expr();match(',');arg3=expr();analyseurtetpil=avma;
	  res=(*f)(arg,arg1,arg2,arg3,prec);break;
	case 10: p1=(*f)(expr());analyseurtetpil=avma;
	  res=stoi(p1);break;
	case 11: arg=expr();if(typ(arg)!=1) err(caseer);
	  analyseurtetpil=avma;res=(*f)(itos(arg),prec);break;
	case 12: arg=expr();match(',');arg1=expr();va=numvar(arg1);
	  analyseurtetpil=avma;res=(*f)(arg,va,precdl);break;
	case 13: arg=expr();analyseurtetpil=avma;
	  res=(*f)(arg,&e);break;
	case 14: arg=expr();match(',');arg1=expr();va=numvar(arg1);
	  analyseurtetpil=avma;res=(*f)(arg,va);break;
	case 15: arg=expr();if(typ(arg)!=1) err(caseer);
	  analyseurtetpil=avma;res=stoi((*f)(itos(arg)));break;
	case 20: arg=expr();match(',');
	  p1=(*f)(arg,expr());analyseurtetpil=avma;
	  res=stoi(p1);break;
	case 21: arg=expr();match(',');arg1=expr();if(typ(arg1)!=1) err(caseer);
	  analyseurtetpil=avma;res=(*f)(arg,itos(arg1));break;
	case 22: arg=expr();match(',');
	  if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = findentry();if (ep->valence!=200) err(varer1,analyseurs);match(',');
	  analyseurtetpil=avma;
	  res=(*f)(ep,arg,analyseurs); skipexpr(); break;
	case 23: arg=expr();match(',');arg1=expr();if(typ(arg1)!=1) err(caseer);
	  analyseurtetpil=avma;res=(*f)(arg,itos(arg1),prec);break;
	case 24: arg=expr();if(typ(arg)!=1) err(caseer);
	  match(',');arg1=expr();analyseurtetpil=avma;
	  res=(*f)(itos(arg),arg1,prec);break;
	case 25: arg=expr();match(',');arg1=expr();analyseurtetpil=avma;
	  res=(*f)(arg,arg1);break;
	case 26: arg=expr();match(',');arg1=expr();
	  va=numvar(arg1);match(',');arg2=expr();
	  analyseurtetpil=avma;res=(*f)(arg,va,arg2);break;
	case 27: if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = findentry();match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  arg=expr(); match(','); analyseurtetpil=avma;
	  res=(*f)(ep,arg,analyseurs,prec); skipexpr(); break;
	case 28: arg=expr();match(',');arg1=expr();
	  analyseurtetpil=avma;res=(*f)(arg,arg1,&e);break;
	case 29: arg=expr();match(',');arg1=expr();if(typ(arg1)!=1) err(caseer);
	  p1=(*f)(arg,itos(arg1));analyseurtetpil=avma;
	  res=stoi(p1);break;
	case 30: arg=expr();match(',');arg1=expr();match(',');
	  p1=(*f)(arg,arg1,expr());analyseurtetpil=avma;
	  res=stoi(p1);break;
	case 31: arg=expr();match(',');arg1=expr();match(',');
	  analyseurtetpil=avma;res=(*f)(arg,arg1,expr(),&arg2);cgiv(arg2);
	  break;
	case 32: arg=expr();match(',');arg1=expr();match(',');arg2=expr();
	  if(typ(arg2)!=1) err(caseer);
	  analyseurtetpil=avma;res=(*f)(arg,arg1,itos(arg2));break;
	case 33: arg=expr();match(',');arg1=expr();match(',');arg2=expr();
	  if((typ(arg2)!=1)||(typ(arg1)!=1)) err(caseer);
	  analyseurtetpil=avma;res=(*f)(arg,itos(arg1),itos(arg2),prec);break;
	case 34: arg1=expr();match(',');arg2=expr();match(',');arg3=expr();
	  analyseurtetpil=avma;
	  res=(*f)(gtolong(arg1),gtolong(arg2),gtolong(arg3));
	  break;
	case 35: arg=expr();match(',');arg1=expr();match(',');arg2=expr();
	  if(typ(arg)!=1) err(caseer);
	  analyseurtetpil=avma;res=(*f)(itos(arg),arg1,arg2);break;
	case 37: if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = findentry();match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  arg=expr(); match(','); arg1=expr(); match(','); 
	  analyseurtetpil=avma;
	  res=(*f)(ep,arg,arg1,analyseurs,prec); skipexpr(); break;
	case 48: arg=expr(); match(',');
	  if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = findentry();match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  arg1=expr(); match(','); arg2=expr(); match(',');
	  analyseurtetpil=avma;
	  res=(*f)(ep,arg,arg1,arg2,analyseurs,prec); skipexpr(); break;
	case 49: arg=expr();match(','); arg1=expr(); match(',');
	  if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = findentry();if (ep->valence!=200) err(varer1,analyseurs);match(',');
	  if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep1 = findentry();if (ep1->valence!=200) err(varer1,analyseurs);match(',');
	  analyseurtetpil=avma;
	  res=(*f)(ep,ep1,arg,arg1,analyseurs); skipexpr(); break;
	case 50: p1=truc();
	  if (*analyseurs++=='^') 
	    {
	      arg=facteur();if(typ(arg)!=1) err(caseer);
	      e=itos(arg);
	    }
	  else {e = 1; analyseurs--;}
	  analyseurtetpil=avma; res = ggrando(p1,e); break;
	case 51: case 52: case 53: case 54: case 55:
	  if (*analyseurs != ')') for(;;)
	    {
	      if (*analyseurs == '"')
		{
		  analyseurs++;
		  while ((*analyseurs)&&(*analyseurs!='"')) pariputc(*analyseurs++);
		  match('"');
		}
	      else
		{
		  analyseurtetpil=avma;
		  if (ep->valence == 55) f = (GEN (*)()) texe;
		  else if(ep->valence&1) f = (GEN (*)()) brute;else f = (GEN (*)()) sor;
		  (*f)(res=expr(),glbfmt[0],glbfmt[2],glbfmt[1]);
		}
	      if (*analyseurs == ')') break;
	      match(',');
	    }
	  if (ep->valence>52) pariputc('\n'); 
	  fflush(outfile); if (logfile) fflush(logfile); break;
	case 56: 
	  readbuffer = (char *)newbloc(paribuffsize>>2);
	  while(!fgets(readbuffer, paribuffsize, infile)) switchin(NULL);
	  if (pariecho) pariputs(readbuffer);
	  else if (logfile) fputs(readbuffer, logfile);
	  res=lisseq(readbuffer);killbloc((GEN)readbuffer);break;
	case 57:
	  arg=expr();if(typ(arg)!=1) err(caseer);
	  match(',');
	  if(*analyseurs!='"') arg1=expr();
	  else
	    {
	      match('"');ch1=(char*)malloc(256);m=0;
	      while ((m<256)&&(*analyseurs)&&(*analyseurs!='"'))
		ch1[m++]=*analyseurs++;
	      match('"');arg1=cgetg(m+1,17);
	      for(i=1;i<=m;i++) arg1[i]=lstoi((long)ch1[i-1]);
	      free(ch1);
	    }
	  analyseurtetpil=avma;res=(*f)(itos(arg),arg1);
	  break;
	case 59: arg=expr();match(',');arg1=expr();match(',');
	  arg2=expr();match(',');arg3=expr();match(',');arg4=expr();
	  analyseurtetpil=avma;
	  res=(*f)(gtolong(arg),gtolong(arg1),gtolong(arg2),gtolong(arg3),gtolong(arg4));
	  break;	  
	case 60: arg=expr();if(typ(arg)!=1) err(caseer);
	  m=itos(arg);if((m>=100)||(m<0)) err(labeler);
	  labellist[m]=analyseurs;break;
	case 61: arg=expr();if(typ(arg)!=1) err(caseer);
	  m=itos(arg);if((m>=100)||(m<0)||(!labellist[m])) err(labeler);
	  analyseurs=labellist[m];yatileugoto=1;break;
	case 80: av = avma; c=gcmp0(expr()); analyseurtetpil = avma = av; match(',');
	  if (c) {skipseq();match(',');res = seq();}
	  else 
	    {
	      yatileugoto=0;res = seq();
	      if(!yatileugoto) {match(',');skipseq();}
	    }
	  break;
	case 81: analyseurtetpil = av = avma; ch1 = analyseurs;
	  while (!gcmp0(expr()))
	    {
	      analyseurtetpil = avma = av; match(',');
	      yatileugoto=0;seq();
	      if(!yatileugoto) analyseurs = ch1;else break;
	    }
	  if(!yatileugoto) {match(','); skipseq();}
	  break;
	case 82: av = avma; ch1 = analyseurs;
	  skipexpr();
	  do 
	    {
	      analyseurtetpil = avma = av; match(','); 
	      yatileugoto=0;seq();
	      if(!yatileugoto) analyseurs = ch1;else break;
	    }
	  while (gcmp0(expr()));
	  if(!yatileugoto) {match(','); skipseq();}
	  break;
	case 83: if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = findentry();match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  arg=expr(); match(','); arg1=expr(); match(','); 
	  analyseurtetpil=avma;
	  res=(*f)(ep,arg,arg1,analyseurs); skipseq(); break;
	case 84: arg=expr();match(',');
	  if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = findentry();if (ep->valence!=200) err(varer1,analyseurs);match(',');
	  analyseurtetpil=avma;
	  res=(*f)(ep,arg,analyseurs); skipseq(); break;
	case 85: if(!isalpha(*analyseurs)) err(killer1);
	  ep = findentry(); if (ep->valence<100) err(killer1);
	  killvalue(ep);
	  if (ep->valence == 200) res = (GEN)ep->value;
	  else
	    {
	      for(i = 0; i<TBLSZ; i++)
		if (hashtable[i] == ep) {hashtable[i] = ep->next; free(ep); break;}
		else
		  for(ep1 = hashtable[i]; ep1; ep1 = ep1->next)
		    if (ep1->next == ep) {ep1->next = ep->next; free(ep); break;}
	    }
	  break;
	case 86: if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = findentry();match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  arg=expr();match(',');arg1=expr();match(',');arg2=expr();match(',');
	  analyseurtetpil=avma;
	  res=(*f)(ep,arg,arg1,arg2,analyseurs); skipseq(); break;
	  
	default: err(valencer1);
	}
      match(')');return res;
    }
  switch (ep->valence)
    {
    case 200: /* variables */
      if((*analyseurs)=='[')
	{
	  tx=typ(p1=(GEN)ep->value);
	  if((tx<17)||(tx>19)) err(caracer1,analyseurs);
	  analyseurs++;av2=avma;flcol=flrow=0;
	  if(tx<19)
	    {
	      arg=expr();if(typ(arg)!=1) err(caseer);
	      c=itos(arg);if((c<1)||(c>=lg(p1))) err(arrayer1);
	    }
	  else
	    {
	      if(lg(p1)==1) err(arrayer1);
	      if(*analyseurs==',')
		{
		  analyseurs++;arg=expr();if(typ(arg)!=1) err(caseer);
		  c=itos(arg);if((c<1)||(c>=lg(p1))) err(arrayer1);
		  flcol=1;
		}
	      else
		{
		  arg=expr();if(typ(arg)!=1) err(caseer);
		  e=itos(arg);if((e<1)||(e>=lg(p1[1]))) err(arrayer1);
		  match(',');
		  if(*analyseurs==']') flrow=1;
		  else
		    {
		      arg1=expr();if(typ(arg1)!=1) err(caseer);
		      c=itos(arg1);
		      if((c<1)||(c>=lg(p1))) err(arrayer1);
		    }
		}
	    }
	  match(']'); avma=av2;
	  if(((*analyseurs)=='=')&&(*(analyseurs+1)!='=')) 
	    {
	      analyseurs++;res=expr();
	      if((tx==19)&&(!flcol))
		{
		  if(flrow)
		    {
		      if((typ(res)!=17)||(lg(res)!=lg(p1))) err(caseer2);
		      for(c=1;c<lg(p1);c++) ((GEN)p1[c])[e]=(long)res[c];
/* maybe lcopy(res[c]) instead ? */
		    }
		  else ((GEN)p1[c])[e]=(long)res;
		}
	      else 
		{
		  if(flcol)
		    {
		      if((typ(res)!=18)||(lg(res)!=lg(p1[1]))) err(caseer2);
		    }
		  p1[c]=(long)res;
		}
	      changevalue(ep, p1);p1=(GEN)ep->value;
	    }
	  analyseurtetpil=avma;
	  if((tx<19)||flcol) return (GEN)p1[c];
	  else
	    {
	      if(flrow) 
		{
		  res=cgetg(lg(p1),17);
		  for(c=1;c<lg(p1);c++) res[c]=((GEN)p1[c])[e];
/* maybe lcopy() instead */
		  return res;
		}
	      else return (GEN)((GEN)p1[c])[e];
	    }
	}
      if(((*analyseurs)=='=')&&(*(analyseurs+1)!='=')) 
	{
	  analyseurs++;changevalue(ep, expr()); 
	}
      analyseurtetpil=avma;return (GEN)ep->value;
      
    case 100: /* fonctions utilisateur */
      ch1 = analyseurs;
      match('(');
      p = (entree **)ep->value;
      nparam = (long)*p++;
      arg1 = arg = cgetg(nparam+1, 17);
      for(i = 0; (i < nparam) && (*analyseurs != ')'); i++)
	{
	  if (i) match(',');
	  *++arg = (long)expr();
	}
      if ((*analyseurs==')') && ((analyseurs[1] != '=') || (analyseurs[2] == '=')))
	{
	  analyseurs++;
	  while(i++ < nparam) *++arg = zero;
	  analyseurtetpil = avma;
	  for(i=0; i<nparam; i++) newvalue(*p++, *++arg1);
	  res = lisseq((char *)p);
          res = forcecopy(res);
	  for(i = 0; i < nparam; i++) 
            killvalue(*--p);
	  return res;
	}
      while (*analyseurs == ',') {analyseurs++; skipexpr();}
      match(')');
      if ((*analyseurs != '=') || (analyseurs[1] == '=')) err(nparamer1);
      analyseurs = ch1;
      killbloc(ep->value);
      
    case 101: /* nouvelle fonction */
      
      match('(');
      ch1 = analyseurs;
      for(nparam = 0; *analyseurs != ')'; nparam++)
	{
	  if (nparam) match(',');
	  if (!isalpha(*analyseurs)) err(paramer1);
	  if (skipentry()->valence != 200) err(paramer1);
	}
      match(')'); match('='); ch2 = analyseurs; skipseq(); 
      p = (entree **)newbloc(nparam + (analyseurs - ch2) / 4 + 2);
      p[-1] = (entree *)ep->value;
      ep->value = (void *)p;
      *p++ = (entree *)nparam;
      ch2 = analyseurs; analyseurs = ch1;
      for(i = 0; i < nparam; i++)
	{
	  if (i) match(',');
	  *p++ = ep1 = findentry();
	  if (ep1->valence != 200) err(paramer1);
	}      
      match(')'); match('=');
      strncpy((char *)p, analyseurs, ch2 - analyseurs);
      *((char *)p + (ch2 - analyseurs)) = 0;
      ep->valence = 100;
      analyseurs = ch2;
      return gnil;
      
    default: err(valencer1);
    }
}

static long  word(nb)
     long *nb;
{
  int m=0;
  for(*nb = 0; (*nb < 9) && isdigit(*analyseurs); (*nb)++)
    m = 10 * m + *analyseurs++-'0';
   return m;
}

GEN constante()
{
  static long pw10[] = {1, 10, 100, 1000, 10000, 100000,
                          1000000, 10000000, 100000000, 1000000000};
  long l,m=0,n=0,plus=1,nb, av = avma, limite=(avma + bot)/2;
  GEN z,y;
  
  analyseurtetpil=avma;
  y = stoi(word(&nb));
  while (isdigit(*analyseurs))
    {
      m = word(&nb); y = mulsi(pw10[nb], y);
      analyseurtetpil = avma;
      y = addsi(m, y);
      if (avma < limite)
        {
          y = gerepile(av, analyseurtetpil, y);
          analyseurtetpil = av;
        }
    }
  if ((*analyseurs!='.')&&(*analyseurs!='e')&&(*analyseurs!='E')) return y;
  if (*analyseurs=='.') 
    {
      analyseurs++;
      while (isdigit(*analyseurs))
        {
          m = word(&nb); y = mulsi(pw10[nb], y);
          analyseurtetpil = avma;
          y = addsi(m, y);
          if (avma < limite)
            {
              y = gerepile(av, analyseurtetpil, y);
              analyseurtetpil = av;
            }
          n -= nb;
        }
    }
  l=lgef(y);if(l<prec) l=prec;
  analyseurtetpil=avma;
  z=cgetr(l);affir(y,z);
  if ((*analyseurs=='e') || (*analyseurs=='E'))
    {
      analyseurs++;
      if (((*analyseurs)=='+') || ((*analyseurs)=='-')) plus=(*analyseurs++=='+');
      m = word(&nb);
      if(isdigit(*analyseurs)) err(expter1);
      if (plus) n += m;else n -= m;
    }
  if (n)
    {
      affsr(10, y = cgetr(l));
      y = gpuigs(y, abs(n));
      analyseurtetpil=avma;
      z = n > 0 ?  mulrr(z, y) : divrr(z, y);
    }
  return z;
}

entree *findentry()
{
  char *olds = analyseurs, *u, *v;
  long sv, n;
  GEN p1;
  entree *ep;
  
  for (n = 0; isalnum(*analyseurs); analyseurs++) n = n << 1 ^ *analyseurs;
  if (n < 0) n = -n; n %= TBLSZ;
  for(ep = hashtable[n]; ep; ep = ep->next)
    {
      for(u = ep->name, v = olds; (*u) && *u == *v; u++, v++);
      if (!*u && (v == analyseurs)) return ep;
    }
  sv = (*analyseurs == '(') ? 0 : 28;
  ep = (entree *)malloc(sizeof(entree) + sv + analyseurs - olds + 1);
  ep->name = (char *)ep + sizeof(entree) + sv;
  for (u = ep->name, v = olds; v < analyseurs;) *u++ = *v++; *u = 0;
  ep->value = (void *)((char *)ep + sizeof(entree));
  ep->next = hashtable[n];
  hashtable[n] = ep;
  p1 = (GEN)ep->value;
  if (*analyseurs == '(') ep->valence = 101;
  else
    {
      if (nvar == MAXVAR) err(trucer1);
      ep->valence = 200;
      p1[0] = 0x0a010004; p1[1] = 0x01000004 + (nvar << 16); p1[2] = zero; p1[3] = un;
      polx[nvar] = p1;
      polvar[nvar+1] = (long)p1;
      p1 += 4;
      p1[0] = 0x0a010003; p1[1] = 0x01000003 + (nvar << 16); p1[2] = un;
      polun[nvar] = p1;
      varentries[nvar++] = ep;
      setlg(polvar, nvar+1);
    }
  return ep;
}



void skipseq()
{
  for(;;)
    {
      while(separe(*analyseurs)) analyseurs++;
      if ((!*analyseurs) || (*analyseurs == ')') || (*analyseurs == ',')) return;
      skipexpr();
      if(!separe(*analyseurs)) return;
    }
}

void skipexpr()
{
  long niveau=3,e1,e2,e3;
  
  e1=e2=e3=0;
  for(;;)
    switch(niveau)
      {
      case 3: e3=1;skipfacteur();
        switch(*analyseurs)
	  {
          case '*': 
          case '/': 
          case '\\':
          case '%': analyseurs++;break;
          default: niveau--;
	  }
        break;
      case 2:
        if(!e3) {niveau++;break;}
        e3=0;e2=1;
        switch(*analyseurs)
	  {
          case '+':
          case '-': analyseurs++;niveau++;break;
          default: niveau--;
	  }
        break;
      case 1: 
        if(!e2) {niveau++;break;}
        e2=0;e1=1;
        switch(*analyseurs)
	  {
          case '<': analyseurs++;
            switch(*analyseurs)
	      {
              case '=':
              case '>': analyseurs++;niveau++;break;
		default : niveau++;break;
	      }
            break;
          case '>': analyseurs++;
            if((*analyseurs)=='=') analyseurs++;
            niveau++; break;
          case '=': 
          case '!': 
            if((analyseurs[1])=='=') {analyseurs+=2;niveau++;}
            break;
          default: niveau--;
	  }
        break;
      case 0: 
        if(!e1) {niveau++;break;}
        e1=0;
        switch(*analyseurs)
	  {
          case '&': analyseurs++;if(*analyseurs=='&') analyseurs++;niveau++;break;
          case '|': analyseurs++;if(*analyseurs=='|') analyseurs++;niveau++;break;
          default: return;
	  }
      }
}

void skipfacteur()
{
  if (((*analyseurs)=='+') || ((*analyseurs)=='-')) analyseurs++;
  skiptruc();
  for (;;) switch(*analyseurs)
    {
    case '^': analyseurs++;skipfacteur(); break;
    case '~': 
    case '_':
    case '\'': analyseurs++;break;
    case '[': 
      analyseurs++;
      if(*analyseurs == ',') {analyseurs++;skipexpr();}
      else
	{
	  skipexpr();
	  if(*analyseurs==',')
	    {
	      analyseurs++;if(*analyseurs != ']') skipexpr();
	    }
	}
      match(']');break;
    case '!': analyseurs++;if((*analyseurs)!='=') break; else analyseurs--;
    default: return;
    }
}

void skiptruc()
{
  long n=0,p=0,m=1;
  
  if (isalpha(*analyseurs)) {skipidentifier(); return;}
  if (isdigit(*analyseurs) || (*analyseurs=='.')) {skipconstante(); return;}
  switch(*analyseurs++)
    {
    case '(': skipexpr();match(')');return;
    case '[': if (*analyseurs!=']') 
      {do {n++; skipexpr();} while (*analyseurs++==',');analyseurs--;}
      switch (*analyseurs++)
	{
        case ']': return;
        case ';': m=n;do {n++; skipexpr();} while (*analyseurs++!=']');
          if (n % m) err(recter1);
          return;
        default: err(vectmater1);
	}
    case '%':
      p=0;while((*analyseurs)=='`') {analyseurs++;p++;}
      if(p>tglobal) err(referer1);
      if(p) return;
      while (isdigit(*analyseurs)) p = 10*p + *analyseurs++ - '0';
      if(p>tglobal) err(referer1);
      return;
    }
  err(caracer1,analyseurs-1);
}

void skipidentifier()
{
  long nparam, i, m;
  entree *ep, **p;
  char *ch1;
  GEN arg;

  ep = skipentry();
  if (ep->valence < 100) /* fonctions predefinies */
    {
      if (!ep->valence && (*analyseurs != '(')) return;
      match('(');
      switch(ep->valence)
	{
	case 0:
	case 56: break;
	case 1:
	case 10:
	case 11:
	case 13:
	case 15:
	case 61: skipexpr(); break;
	case 60: arg=expr();if(typ(arg)!=1) err(caseer);
	  m=itos(arg);if((m>=100)||(m<0)) err(labeler);
	  labellist[m]=analyseurs;break;
	case 51: case 52: case 53: case 54: case 55:
	  if (*analyseurs != ')') for(;;)
	    {
	      if (*analyseurs == '"')
		{
		  analyseurs++;
		  while ((*analyseurs)&&(*analyseurs!='"')) analyseurs++;
		  match('"');
		}
	      else skipexpr();
	      if (*analyseurs == ')') break;
	      match(',');
	    }
	  break;
	case 57:
	  skipexpr();match(',');if(*analyseurs!='"') skipexpr();
	  else
	    {
	      match('"');m=0;
	      while ((m<256)&&(*analyseurs)&&(*analyseurs!='"')) 
		{m++;analyseurs++;}
	      match('"');
	    }
	  break;
	case 2:
	case 12:
	case 14:
	case 20:
	case 21:
	case 23:
	case 24:
	case 25:
	case 28:
	case 29: skipexpr(); match(','); skipexpr(); break;
	case 22: skipexpr(); match(',');
	  if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = skipentry(); if (ep->valence!=200) err(varer1,analyseurs);
	  match(','); skipexpr(); break;
	case 27: if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = skipentry(); match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  skipexpr(); match(','); skipexpr(); break;
	case 3:
	case 26: 
	case 30:
	case 31:
	case 32:
	case 33:
	case 34:
	case 35: skipexpr();match(',');skipexpr();match(',');skipexpr();
	  break;
	case 37: if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = skipentry(); match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  skipexpr(); match(','); skipexpr(); match(','); skipexpr();break;
	case 4: skipexpr();match(',');skipexpr();match(',');skipexpr();
	  match(',');skipexpr();break;
	case 48: skipexpr(); match(',');
	  if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = skipentry(); match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  skipexpr(); match(','); skipexpr(); match(','); skipexpr();break;
	case 49: skipexpr(); match(','); skipexpr(); match(',');
	  if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = skipentry(); if (ep->valence!=200) err(varer1,analyseurs);
	  match(',');if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = skipentry(); if (ep->valence!=200) err(varer1,analyseurs);
	  match(','); skipexpr(); break;
	case 50: skiptruc();
	  if (*analyseurs++=='^') skipfacteur();else analyseurs--;
	  break;
	case 59: skipexpr();match(',');skipexpr();match(',');skipexpr();
	  match(',');skipexpr();match(',');skipexpr();break;
	case 80: skipexpr(); match(','); skipseq(); match(','); skipseq(); break;
	case 81:
	case 82: skipexpr(); match(','); skipseq(); break;
	case 83: if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = skipentry(); match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  skipexpr(); match(','); skipexpr(); match(','); skipseq(); break;
	case 84: skipexpr(); match(',');
	  if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = skipentry(); if (ep->valence!=200) err(varer1,analyseurs);
	  match(','); skipseq(); break;
	case 85: if(!isalpha(*analyseurs)) err(killer1);
	  ep = skipentry(); if (ep->valence<100) err(killer1);
	  break;
	case 86: if(!isalpha(*analyseurs)) err(varer1,analyseurs);
	  ep = skipentry(); match('='); if (ep->valence!=200) err(varer1,analyseurs);
	  skipexpr();match(',');skipexpr();match(',');skipexpr();match(',');skipseq();break;
	default: err(valencer1);
	}
      match(')');
      return;
    }
  switch (ep->valence)
    {
    case 200: /* variables */
      if((*analyseurs)=='[')
	{
	  analyseurs++;
	  if(*analyseurs == ',') {analyseurs++;skipexpr();}
	  else
	    {
	      skipexpr();
	      if(*analyseurs == ',')
		{
		  analyseurs++;if(*analyseurs != ']') skipexpr();
		}
	    }
	  match(']');
	}
      if(((*analyseurs)=='=')&&(*(analyseurs+1)!='=')) 
	{
	  analyseurs++;skipexpr(); 
	}
      return;
      
    case 100: /* fonctions utilisateur */
      ch1 = analyseurs;
      match('(');
      p = (entree **)ep->value;
      nparam = (long)*p++;
      i = 0;
      for(i = 0; (i < nparam) && (*analyseurs != ')'); i++)
	{
	  if (i) match(',');
	  skipexpr();
	}
      if ((*analyseurs==')') && ((analyseurs[1] != '=') || (analyseurs[2] == '='))) {analyseurs++; return;}
      while (*analyseurs == ',') {analyseurs++; skipexpr();}
      match(')');
      if ((*analyseurs != '=') || (analyseurs[1] == '=')) err(nparamer1);
      analyseurs = ch1;
      
    case 101: /* nouvelle fonction */
      
      match('(');
      for(nparam = 0; *analyseurs != ')'; nparam++)
	{
	  if (nparam) match(',');
	  skipexpr();
	};
      match(')');
      if (*analyseurs == '=') {analyseurs++; skipseq();}
      return;
      
    default: err(valencer1);
    }
}

void skipconstante()
{  
  while (isdigit(*analyseurs)) analyseurs++;
  if ((*analyseurs!='.')&&(*analyseurs!='e')&&(*analyseurs!='E')) return;
  if (*analyseurs=='.') analyseurs++;
  while (isdigit(*analyseurs)) analyseurs++;
  if ((*analyseurs=='e') || (*analyseurs=='E'))
    {
      analyseurs++;
      if (((*analyseurs)=='+') || ((*analyseurs)=='-')) analyseurs++;
      while (isdigit(*analyseurs)) analyseurs++;
    }
}

entree fake101 = {"",101,0,0};
entree fake200 = {"",200,0,0};

entree *skipentry()
{
  char *u, *v, *olds = analyseurs;
  long n;
  entree *ep;
  
  for(n = 0; isalnum(*analyseurs); analyseurs++) n = n << 1 ^ *analyseurs;
  if (n < 0) n = -n; n %= TBLSZ;
  for(ep = hashtable[n]; ep; ep = ep->next)
    {
      for(u = ep->name, v = olds; (*u) && *u == *v; u++, v++);
      if (!*u && (v == analyseurs)) return ep;
    }
  return (*analyseurs == '(') ? &fake101 : &fake200;
}
