/*
 * p4_args.c   Code that looks at the arguments, recognizes any that are
 *             for p4, uses the arguments, and removes them from the
 *             command line args.
 */
#include "p4.h"
#include "p4_sys.h"

/* Macro used to see if an arg is not following the correct format. */
#define bad_arg(a)    ( ((a)==NULL) || ((*(a)) == '-') )

static char pgm[100];		/* Used to keep argv[0] for the usage cmd. */

static P4VOID usage();
static P4VOID print_version_info();
static P4VOID strip_out_args();


P4VOID process_args(argc, argv)
int *argc;
char **argv;
{
    char *s, **a;
    int c;

    /* Put the name of the called program (according to the args) into pgm */
    s = (char *)  rindex(*argv, '/');
    if (s)
	strcpy(pgm, s + 1);
    else
	strcpy(pgm, *argv);

    /* Set all command line flags to their default. */
    debug_level = 0;
    remote_debug_level = 0;
    strcpy(bm_outfile, "");
    strcpy(procgroup_file, "procgroup");
    strcpy(local_domain, "");

    /* Move to last argument, so that we can go backwards. */
    a = &argv[*argc - 1];

    /*
     * Loop backwards through arguments, catching the ones that start with
     * '-'.  Backwards is more efficient when you are stripping things out.
     */
    for (c = (*argc); c > 1; c--, a--)
    {

	if (**a != '-')
	    continue;

	if (!strcmp(*a, "-pg"))
	{
	    if (bad_arg(a[1]))
		usage();
	    strcpy(procgroup_file, a[1]);
	    strip_out_args(a, argc, &c, 2);
	    continue;
	}
	if (!strcmp(*a, "-dbg"))
	{
	    if (bad_arg(a[1]))
		usage();
	    debug_level = atoi(a[1]);
	    strip_out_args(a, argc, &c, 2);
	    continue;
	}
	if (!strcmp(*a, "-ssport"))
	{
	    if (bad_arg(a[1]))
		usage();
	    sserver_port = atoi(a[1]);
	    strip_out_args(a, argc, &c, 2);
	    continue;
	}
	if (!strcmp(*a, "-rdbg"))
	{
	    if (bad_arg(a[1]))
		usage();
	    remote_debug_level = atoi(a[1]);
	    strip_out_args(a, argc, &c, 2);
	    continue;
	}
	if (!strcmp(*a, "-gm"))
	{
	    if (bad_arg(a[1]))
		usage();
	    globmemsize = atoi(a[1]);
	    strip_out_args(a, argc, &c, 2);
	    continue;
	}
	if (!strcmp(*a, "-dmn"))
	{
	    if (bad_arg(a[1]))
		usage();
	    strcpy(local_domain, a[1]);
	    strip_out_args(a, argc, &c, 2);
	    continue;
	}
	if (!strcmp(*a, "-out"))
	{
	    if (bad_arg(a[1]))
		usage();
	    strcpy(bm_outfile, a[1]);
	    strip_out_args(a, argc, &c, 2);
	    continue;
	}
	if (!strcmp(*a, "-rout"))
	{
	    if (bad_arg(a[1]))
		usage();
	    strcpy(rm_outfile_head, a[1]);
	    strip_out_args(a, argc, &c, 2);
	    continue;
	}
	if (!strcmp(*a, "-p4log"))
	{
	    strip_out_args(a, argc, &c, 1);
	    logging_flag = TRUE;
	    continue;
	}
	if (!strcmp(*a, "-p4version"))
	{
	    strip_out_args(a, argc, &c, 1);
	    print_version_info();
	    continue;
	}
	if (!strcmp(*a, "-?") || !(strcmp(*a, "-help")))
	    usage();
    }
}

static P4VOID strip_out_args(argv, argc, c, num)
char **argv;
int *argc, *c, num;
{
    char **a;
    int i;

    /* Strip out the argument. */
    for (a = argv, i = (*c); i <= *argc; i++, a++)
	*a = (*(a + num));
    (*argc) -= num;
}

static P4VOID usage()
{
    print_version_info();
    printf("p4 usage: %s options\n", pgm);
    printf("Valid options:\n");
    printf("\t-help   \tget this message\n");
    printf("\t-pg     \tprocgroup_file\n");
    printf("\t-dbg    \tset debug level\n");
    printf("\t-rdbg   \tset remote debug level\n");
    printf("\t-gm     \tset globmemsize\n");
    printf("\t-dmn    \tdomainname\n");
    printf("\t-out    \tfile \toutput file for master\n");
    printf("\t-rout   \tfile \toutput file prefix for remote masters\n");
    printf("\t-ssport \tport# private port number for secure server \n");
    printf("\t-p4log  \tenable internal p4 logging by alog; only works if p4 made with alog\n");
    printf("\t-p4version \tprint current p4 version number\n");
    printf("\n");
    exit(-1);
}

static P4VOID print_version_info()
{
        printf("\n");
        printf("p4 version number:  %s\n",p4_version());
        printf("p4  date compiled:  %s\n",P4_COMPILED_TIME);
        printf("p4   machine type:  %s\n",P4_MACHINE_TYPE);
#ifdef P4_DPRINTFL
        printf("   P4_DPRINTFL is:  on\n");
#else
        printf("   P4_DPRINTFL is:  off\n");
#endif
#ifdef ALOG_TRACE
        printf("    ALOG_TRACE is:  on\n");
#else
        printf("    ALOG_TRACE is:  off\n");
#endif
#if defined(SUN_IPC) || defined(DEC5000_IPC) || defined(RS6000_IPC) || defined(IBM3090_IPC) || \
    defined(HP_IPC)  || defined(TITAN_IPC)   || defined(SGI_IPC)
        printf("      SYSV IPC is:  on\n");
#else
        printf("      SYSV IPC is:  off\n");
#endif
        printf("\n");
}
