#include "xhist.h"

extern double data[MAXINPUTS];
extern int numvalues,all,num_proc,*proclist;
extern char color[50],*procliststr;

void InputData(argc,argv)
int argc;
char *argv[];
{
    FILE *logfile;
    int start,end;
    int event_type,proc,t;
    double started[MAXNUMPROCS];
    int i,len;
    char line[100];

    /* Read data from the parent process */

    if((argc < 5)||(argc > 6)){
	printf("usage: xhist <log file> <start> <end> <color> [\"process list\"]\n");
	exit(1);
	}
    else if(argc == 5){
	all = TRUE;
	procliststr = (char *)calloc(5,sizeof(char));
	}
    else{
	all = FALSE;
	len = strlen(argv[5]);
	proclist = (int *)calloc(len/2,sizeof(int));
	procliststr = (char *)calloc(len+1,sizeof(char));
	strcpy(procliststr,argv[5]);
	get_procnum(procliststr);
	strcpy(procliststr,argv[5]);
	}
    
    if ((logfile = fopen(argv[1],"r")) == NULL){
 	printf("can't open logfile %s\n",argv[1]);
 	exit(1);
        }
    start = atoi(argv[2]);
    end = atoi(argv[3]);
    strcpy(color,argv[4]);

    /* Read in the values */

    i = 0;
    if(all){
	/* all processes */
	while(fgets(line,sizeof(line),logfile) != NULL){
	    if(sscanf(line,"%d %d %*d %*d %*d %d",&event_type,&proc,&t) == 3)
		;
            else if(sscanf(line,"%d %d %*d %*d %*d %d %*s",&event_type,
			   &proc,&t) == 3)
		;
	    else
		printf("invalid : %s\n",line);

	    if(event_type == start){
		started[proc] = (double) t;
		}
	    else if(event_type == end){
		data[i] = (double) t - started[proc];
		i++;
		}
	    } /* End of the while loop */
	}

    else{
	/* particular process */
        while(fgets(line,sizeof(line),logfile) != NULL){
	    if(sscanf(line,"%d %d %*d %*d %*d %d",&event_type,&proc,&t) == 3)
		;
	    else if(sscanf(line,"%d %d %*d %*d %*d %d %*s",&event_type,
			   &proc,&t) == 3)
		;
	    else
		printf("invalid : %s\n", line);

	    if(proc_in_proclist(proc,proclist,num_proc)){
		if(event_type == start){
		    started[proc] = (double) t;
		    }
		else if(event_type == end){
		    data[i] = (double) t - started[proc];
		    i++;
		    }
		}

	    } /* End of the while loop */
    	}


    numvalues = i;

    /*printf("\n  number of values plotted:  %d\n", i);*/

    /* Use QuickSort to sort the values */

    qsort(data,numvalues,sizeof(double),comp);

    /* Sort the process list */

    if(!all) qsort(proclist,num_proc,sizeof(int),comp);

    fclose(logfile);

}  /* End of Function InputData */

/* COMP
   This function's sole purpose it to make QSORT work */

int comp(i,j)
int *i;
int *j;
{
    
    return *i - *j;

}  /* End of Function Comp */


/* PROC_IN_PROCLIST
   This function determines whether a process 
   is included in the process list */

proc_in_proclist(proc,proclist,num_proc)
int proc,proclist[],num_proc;
{
    int i;

    for(i=0;i<num_proc;++i){
	if(proc == proclist[i])
	    return(1);
	}

    return(0);
}


/* GET_PROCNUM
   Given a string of integers, this function stores those integers
   in an array of int -- proclist */

get_procnum(str)
char str[];
{

    int i,j,k;

    for(i=j=k=0;str[i]!=NULL;){
	for(;(str[j]==' ')||(str[j]=='\t');++j);
	i = j;
	for(;(str[j]!=' ')&&(str[j]!='\t')&&(str[j]!=NULL);++j);
	if(str[j]!=NULL)
	    str[j++] = NULL;
	if(i!=j){
	    proclist[k++] = atoi(&str[i]);
	    i = j;
	    }
	}


    num_proc = k;
}
